<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>

<div id="wrapper">
    <div class="content">
        <div class="row">
            <div class="col-md-12">
                <div class="panel_s">
                    <div class="panel-body">
                        <div class="row">
                            <div class="col-md-12 mb-4">
                                <h3 class="no-margin font-bold"><i class="fa <?php echo $icon ?>" aria-hidden="true"></i> <?php echo $title; ?></h3>
                            </div>
                            <div class="col-md-12"><hr/></div>
                        </div>
                        <?php echo form_open(admin_url('restoration/template/add_edit'.($id ? '/' . $id : '')), ['id' => 'form_add_edit']); echo form_hidden('id',$id)?>
                            <div class="row">
                                <div class="col-md-6">
                                    <?php
                                        $value = (isset($template->title) ? $template->title : '');
                                        echo render_input('title', 'Title', $value, 'text');
                                    ?>
                                </div>
                                <div class="col-md-6">
                                    <?php
                                        $value = (isset($template) ? $template->category : '');
                                        echo render_select('category', $category, ['id', 'title'], 'Category', $value, ['data-live-search' => false], [], '', '', true);
                                        ?>
                                </div>
                                <div class="col-md-12"><hr/></div>
                            </div>

                            <div class="row">
                                <div id="field_div" class="col-md-12">
                                    <?php
                                    if(isset($template_table)){
                                        foreach ($template_table as $key => $value) {
                                            $this->load->view('restoration/template/newcomponent', ['index' => $key, 'template' => $value]);
                                        }
                                    }
                                    ?>
                                </div>
                            </div>
                            <div class="col-md-12 text-right">
                                <a href="<?php echo admin_url('restoration/template') ?>" class="btn btn-default"><?php echo _l('cancel'); ?></a>
                                <button type="submit" class="btn btn-primary"><?php echo _l('Save'); ?></button>
                            </div>
                        <?php echo form_close(); ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php init_tail(); ?>
<script>
   
    jQuery(document).ready(() => {
        $('.selectpicker').selectpicker('refresh');
        if($('.new_component').length == 0){
            newcomponent(0);
        }
        $("#form_add_edit").appFormValidator({
            rules:{
                title: 'required',
                category:'required',
            },
            errorPlacement: function(error, element) {
                $(error).addClass('text-danger');
                error.appendTo( element.parents(".form-group"));
            },
            submitHandler: function(form) {
                add_edit_form_handler(form);
            },
            highlight: function(element, errorClass) {
                $(element).parents('.form-group').addClass("has-error");
            }
        });

        // $("#table_column").blur(function() {
        $(document).on("blur", "input[name^='table_column']", function(){
            var column = $(this).val();
            var data_index = $(this).data('index');
            $.post(admin_url + 'restoration/template/tablecolumn/', {column: column, index: data_index})
                .done(function (response) {
                    response = JSON.parse(response);
                    if (response.success === true || response.success == 'true') {
                        $("#table_column_div_"+response.index).html(response.html);
                    } else {
                        alert_float('danger', response.message);
                    }
                })
                .fail(function (error) {
                    alert_float('danger', JSON.parse(error.responseText));
                });
        });

        $(document).on("click", "a.addnewcomponent", function(){
            var length = $('.new_component').length;
            newcomponent(length);
        });

        $(document).on("click", "a.removecomponent", function(){
            $(this).parent().parent().remove();
        });

        $(document).on("change", "select[name^='field_type']", function(){
            var data_index = $(this).data('index');
            if($(this).val() == 'table'){
                $(".table_component_"+data_index).removeClass('d-none');
            }else{
                $(".table_component_"+data_index).addClass('d-none');
            }
        });

        function newcomponent(index) {
            $.post(admin_url + 'restoration/template/newcomponent/',{index:index})
            .done(function (response) {
                response = JSON.parse(response);
                if (response.success === true || response.success == 'true') {
                    $("#field_div").append(response.html);
                } else {
                    alert_float('danger', response.message);
                }
            })
            .fail(function (error) {
                alert_float('danger', JSON.parse(error.responseText));
            });
        }
        
    });

    function add_edit_form_handler(form){
        $("#add_loader").removeClass('d-none');
        let formURL = form.action;
        let formData = new FormData($(form)[0]);
        $.ajax({
            type: $(form).attr('method'),
            data: formData,
            mimeType: $(form).attr('enctype'),
            contentType: false,
            cache: false,
            processData: false,
            url: formURL
        }).done(function (response) {
            $("#add_loader").addClass('d-none');
            response = JSON.parse(response);
            if (response.success === true || response.success == 'true') {
                alert_float('success', response.message);
                window.location = admin_url+"restoration/template";
            } else {
                alert_float('danger', response.message);
            }

        }).fail(function (error) {
            alert_float('danger', JSON.parse(error.responseText));
        });
    }

</script>
