<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<div id="wrapper">
	<div class="content">
		<div class="row">
			<div class="col-md-12">

				<div class="panel_s">
					<div class="panel-body">
						<div class="row">
                            <div class="col-md-6">
                                <h4 class="no-margin font-bold"><i class="fa <?php echo $icon ?>" aria-hidden="true"></i> <?php echo $title; ?></h4>
                            </div>
							<div class="col-md-6 text-right">
								<a href="<?= admin_url('restoration/projects/project'); ?>" class="btn btn-primary "><?php echo _l('restoration_create'); ?></a>
							</div>
                            <div class="col-md-12">
                                <hr/>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <?php
                                $table_data = array(
                                    _l('Project Name'),
                                    _l('Start Date'),
									_l('Dead Line'),
									_l('restoration_table_action'),
                                    );
                                render_datatable($table_data,'projects');
                                ?>
                            </div>
                        </div>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>
<?php init_tail(); ?>
<script>
	let arrayArray = [];
	$(function(){
		let fnServerParams = {
		}
		initDataTable('.table-projects', admin_url + 'restoration/projects/index', [], arrayArray,fnServerParams, []);
	});

    function delete_task(id){
		if (confirm_delete()) {
			$.post(admin_url + 'restoration/projects/delete/' +id)
			.done(function (response) {
				response = JSON.parse(response);
				if (response.success === true || response.success == 'true') {
					alert_float('danger', response.message);
					$(".btn-dt-reload").trigger('click');
				} else {
					alert_float('danger', response.message);
				}
			})
			.fail(function (error) {
				alert_float('danger', JSON.parse(error.responseText));
			});
		}
	}
</script>
</body>
</html>
