<?php /** @noinspection SqlNoDataSourceInspection */
defined('BASEPATH') or exit('No direct script access allowed');

if (!function_exists('init_re_transaction_remove_database_tables')) {
    /**
     * Init installation tables creation in database
     */
    function init_re_transaction_remove_database_tables(): void
    {
        $CI = &get_instance();

        $CI->db->query("SET FOREIGN_KEY_CHECKS=0;");
        $CI->db->query("START TRANSACTION;");

        foreach ([
                     RE_TRANSACTION_TABLE_TRANSACTION_MEMBERS,
                     RE_TRANSACTION_TABLE_TRANSACTION_TRUST_ACCOUNTS,
                     RE_TRANSACTION_TABLE_TRANSACTION_NOTES,
                     RE_TRANSACTION_TABLE_TRANSACTION_DOCUMENTS,
                     RE_TRANSACTION_TABLE_TRANSACTION_CHECKLIST_ITEMS,
                     RE_TRANSACTION_TABLE_TRANSACTION_AGENTS,
                     RE_TRANSACTION_TABLE_TRANSACTION_ACTIVITY_LOGS,
                     RE_TRANSACTION_TABLE_TRANSACTIONS,

                     RE_TRANSACTION_TABLE_PROPERTY_TYPES,

                     RE_TRANSACTION_TABLE_CITIES,
                     RE_TRANSACTION_TABLE_STATES,
                     RE_TRANSACTION_TABLE_COUNTRIES,

                     RE_TRANSACTION_TABLE_CLOSING_VENDORS,

                     RE_TRANSACTION_TABLE_COMMISSION_PLAN_PRE_COMMISSIONS,
                     RE_TRANSACTION_TABLE_COMMISSION_PLAN_COMMISSION_LEVELS,
                     RE_TRANSACTION_TABLE_COMMISSION_PLAN_CLOSING_FEES,
                     RE_TRANSACTION_TABLE_COMMISSION_PLANS,

                     RE_TRANSACTION_TABLE_FEES,
                     RE_TRANSACTION_TABLE_CO_BROKES,
                     RE_TRANSACTION_TABLE_BILLING_ITEMS,

                     RE_TRANSACTION_TABLE_ZIPCODES,
                     RE_TRANSACTION_TABLE_CHECKLISTS,
                     RE_TRANSACTION_TABLE_CHECKLIST_ITEMS,
                     RE_TRANSACTION_TABLE_AGENTS,
                     RE_TRANSACTION_TABLE_TRANSACTION_AGENT_RECRUIT_SOURCE_PAYMENTS,
                     RE_TRANSACTION_TABLE_TRANSACTION_META,
                     RE_TRANSACTION_TABLE_TRANSACTION_AGENT_CLOSING_FEES,
                     RE_TRANSACTION_TABLE_TRANSACTION_AGENT_POST_COMMISSIONS,
                     RE_TRANSACTION_TABLE_TRANSACTION_AGENT_PRE_COMMISSIONS,
                     RE_TRANSACTION_TABLE_TRANSACTION_AGENT_GARNISHMENTS,
                     RE_TRANSACTION_TABLE_TRANSACTION_AGENT_NOTES,
                     RE_TRANSACTION_TABLE_TRANSACTION_AGENT_OTHER_INCOME,
                     RE_TRANSACTION_TABLE_TRANSACTION_AGENT_DOCUMENT,
                     RE_TRANSACTION_TABLE_TRANSACTION_AGENT_MLSINFO,
                     RE_TRANSACTION_TABLE_TRANSACTION_AGENT_BILLING_ITEMS,
                     RE_TRANSACTION_TABLE_TRANSACTION_AGENT_BILLINGS,
                     RE_TRANSACTION_TABLE_TRANSACTION_AGENT_CHECKLIST,
                     RE_TRANSACTION_TABLE_TRANSACTION_AGENT_ITEMS_CHECKLIST,
                     RE_TRANSACTION_TABLE_TRANSACTION_AGENT_TASK_CHECKLIST,
                     RE_TRANSACTION_TABLE_TRANSACTION_AGENT_TASK_CHECKLIST_ITEMS,
                     RE_TRANSACTION_TABLE_TRANSACTION_AGENT_TASK_CHECKLIST_ITEMS_NOTES,
                     RE_TRANSACTION_TABLE_TRANSACTION_AGENT_REAL_ESTATE_LICENSE,
                     RE_TRANSACTION_TABLE_TRANSACTION_ORGANIZATION_OFFICES,
                     RE_TRANSACTION_TABLE_TRANSACTION_ORGANIZATION_REGION_DIVISIONS,
                     RE_TRANSACTION_TABLE_TRANSACTION_AGENT_OFFICES,
                     RE_TRANSACTION_TABLE_OFFICE_DOCUMENT_FOLDER,
                     RE_TRANSACTION_TABLE_OFFICE_DOCUMENT_FOLDER_FILES,
                     RE_TRANSACTION_TABLE_ONBOARDING_TEMPLATE,
                     RE_TRANSACTION_TABLE_ONBOARDING_TEMPLATE_DOCUMENT,
                     RE_TRANSACTION_TABLE_AGENT_ONBOARDING,
                     RE_TRANSACTION_TABLE_EMAIL_TEMPLATE_ONBOARD,
                     RE_TRANSACTION_TABLE_AGENT_TEAMS,
                     RE_TRANSACTION_TABLE_AGENT_TEAMS_TEAM_MEMBERS,
                     RE_TRANSACTION_TABLE_ONBOARDING_DOCUMENT,
                     RE_TRANSACTION_TABLE_SETTINGS,
                     RE_TRANSACTION_TABLE_AGENTS_BILLINGS_LOGS,
                     RE_TRANSACTION_TABLE_ALL_AGENT_BILLINGS,
                     RE_TRANSACTION_TABLE_TRANSACTIONS_MASTERDATA,
                     RE_TRANSACTION_TABLE_REPORT_FAVORITE_FILTER,
                     RE_TRANSACTION_TABLE_INTEGRATION_OPTIONS,
                     RE_TRANSACTION_TABLE_INTEGRATION_LOG,
                     RE_TRANSACTION_TABLE_TRANSACTION_AGENT_HISTORY,
                     RE_TRANSACTION_TABLE_INTEGRATION_SYNC_REQUEST,
                     RE_TRANSACTION_TABLE_INTEGRATION_SYNC_REQUEST_LOGS,
                     RE_TRANSACTION_REPORTS,
                     RE_TRANSACTION_REPORTS_GROUP,
                     RE_TRANSACTION_AGENT_COMMISSION_PLAN_ROLLOVER_DATE_LOGS,
                     RE_TRANSACTION_REPORT_BUILDER_EMAIL_NOTIFICATION,
                     RE_TRANSACTION_TABLE_TRANSACTION_DISBURSEMENT,
                     RE_TRANSACTION_TABLE_TRANSACTION_DISBURSEMENT_ITEM,
                     RE_TRANSACTION_TABLE_TRANSACTION_DISBURSEMENT_CAP_ITEM,
                     RE_TRANSACTION_TABLE_TRANSACTION_DISBURSEMENT_AGENTS_COMMISSION,
                     RE_TRANSACTION_TABLE_TRANSACTION_DISBURSEMENT_COMMISSION_PLAN_CAP,

                 ] as $tableName) {

            $CI->db->query(
                "DROP TABLE IF EXISTS " . $tableName . ";"
            );
        }
        $CI->db->query("ALTER TABLE `tblstaff` DROP `deleted_at`");
        $CI->db->query("SET FOREIGN_KEY_CHECKS=1;");
        $CI->db->query("COMMIT;");
    }
}

if (!function_exists('init_re_transaction_uninstall_sequence')) {
    /**
     * Initialize tables content example data for email templates and sms in database
     */
    function init_re_transaction_uninstall_sequence(): void
    {
        init_re_transaction_remove_database_tables();
    }
}
