<?php /** @noinspection SqlNoDataSourceInspection */
defined('BASEPATH') or exit('No direct script access allowed');

if (!function_exists('init_re_transaction_database_tables')) {
    /**
     * Init installation tables creation in database
     */
    function init_re_transaction_database_tables(): void
    {
        $CI = &get_instance();
        $seederBasePath = dirname(__DIR__) . '/migrations/seeder';
        $tableBasePath = dirname(__DIR__) . '/migrations/table';

        /* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
        /* Install Geo tables */
        /* Countries */
        $sqlCountries = file_get_contents($seederBasePath . "/countries.sql");

        $sqls = explode(';', $sqlCountries);

        foreach ($sqls as $statement) {
            $statement = str_replace('`countries`', '`' . RE_TRANSACTION_TABLE_COUNTRIES . '`', $statement) . ";";
            $CI->db->query($statement);
        }

        /* States */
        $sqlStates = file_get_contents($seederBasePath . "/states.sql");

        $sqls = explode(';', $sqlStates);

        foreach ($sqls as $statement) {
            $statement = str_replace('`states`', '`' . RE_TRANSACTION_TABLE_STATES . '`', $statement) . ";";
            $CI->db->query($statement);
        }
        /* Zip code */
        $sqlZipCode = file_get_contents($seederBasePath . "/zipcode.sql");

        $sqls = explode(';', $sqlZipCode);

        foreach ($sqls as $statement) {
            if(!empty($statement)){
                $CI->db->query($statement);
            }
        }

        /* Cities */
        /*$sqlCities = file_get_contents($seederBasePath . "/cities.sql");

        $sqls = explode(';', $sqlCities);

        foreach ($sqls as $statement) {
            $statement = str_replace('`cities`', '`' . RE_TRANSACTION_TABLE_CITIES . '`', $statement) . ";";
            $CI->db->query($statement);
        }*/

        /* Master Tables */
        if (!$CI->db->table_exists(RE_TRANSACTION_TABLE_FEES)) {

            /* Create table structure */
            $sqlSchema = file_get_contents($tableBasePath . "/master.sql");

            $sqls = explode(';', $sqlSchema);

            $arrTables = [
                'property_types' => RE_TRANSACTION_TABLE_PROPERTY_TYPES,
                'billing_items' => RE_TRANSACTION_TABLE_BILLING_ITEMS,
                // 'closing_vendors' => RE_TRANSACTION_TABLE_CLOSING_VENDORS,
                'co_brokes' => RE_TRANSACTION_TABLE_CO_BROKES,
                'fees' => RE_TRANSACTION_TABLE_FEES,
                'checklists' => RE_TRANSACTION_TABLE_CHECKLISTS,
                'checklist_items' => RE_TRANSACTION_TABLE_CHECKLIST_ITEMS,
                'masterdata' => RE_TRANSACTION_TABLE_TRANSACTIONS_MASTERDATA,
                'meta' => RE_TRANSACTION_TABLE_TRANSACTION_META,
            ];

            $orgTable = array_map(function ($val) {
                return "`$val`";
            }, array_keys($arrTables));

            $newTable = array_map(function ($val) {
                return "`$val`";
            }, array_values($arrTables));

            foreach ($sqls as $statement) {
                if (trim($statement)) {
                    $statement = str_replace($orgTable, $newTable, $statement) . ";";

                    //file_put_contents(__DIR__. '/sql.log', $statement, FILE_APPEND);
                    $CI->db->query($statement);
                }
            }

            /* Master Data */
            $sqlData = file_get_contents($seederBasePath . "/master.sql");

            $sqls = explode(';', $sqlData);

            foreach ($sqls as $statement) {
                if (trim($statement)) {
                    $statement = str_replace($orgTable, $newTable, $statement) . ";";
                    $CI->db->query($statement);
                }
            }
        }

        /* Commission Plan */
        if (!$CI->db->table_exists(RE_TRANSACTION_TABLE_COMMISSION_PLANS)) {

            /* Create table structure */
            $sqlSchema = file_get_contents($tableBasePath . "/commission_plans.sql");

            $sqls = explode(';', $sqlSchema);

            $arrTables = [
                'commission_plans' => RE_TRANSACTION_TABLE_COMMISSION_PLANS,
                'commission_plan_closing_fees' => RE_TRANSACTION_TABLE_COMMISSION_PLAN_CLOSING_FEES,
                'commission_plan_commission_levels' => RE_TRANSACTION_TABLE_COMMISSION_PLAN_COMMISSION_LEVELS,
                'commission_plan_pre_commissions' => RE_TRANSACTION_TABLE_COMMISSION_PLAN_PRE_COMMISSIONS,
            ];

            $orgTable = array_map(function ($val) {
                return "`$val`";
            }, array_keys($arrTables));

            $newTable = array_map(function ($val) {
                return "`$val`";
            }, array_values($arrTables));

            foreach ($sqls as $statement) {
                if (trim($statement)) {
                    $statement = str_replace($orgTable, $newTable, $statement) . ";";

                    //file_put_contents(__DIR__. '/sql.log', $statement, FILE_APPEND);
                    $CI->db->query($statement);
                }
            }

            /* Master Data */
            $sqlData = file_get_contents($seederBasePath . "/commission_plans.sql");

            $sqls = explode(';', $sqlData);

            foreach ($sqls as $statement) {
                if (trim($statement)) {
                    $statement = str_replace($orgTable, $newTable, $statement) . ";";
                    $CI->db->query($statement);
                }
            }
        }

        /* Transaction */
        if (!$CI->db->table_exists(RE_TRANSACTION_TABLE_TRANSACTIONS)) {

            /* Create table structure */
            $sqlSchema = file_get_contents($tableBasePath . "/transaction.sql");

            $sqls = explode(';', $sqlSchema);

            $arrTables = [
                'transactions' => RE_TRANSACTION_TABLE_TRANSACTIONS,
                'transaction_activity_logs' => RE_TRANSACTION_TABLE_TRANSACTION_ACTIVITY_LOGS,
                'transaction_agents' => RE_TRANSACTION_TABLE_TRANSACTION_AGENTS,
                'transaction_checklist_items' => RE_TRANSACTION_TABLE_TRANSACTION_CHECKLIST_ITEMS,
                'transaction_documents' => RE_TRANSACTION_TABLE_TRANSACTION_DOCUMENTS,
                'transaction_notes' => RE_TRANSACTION_TABLE_TRANSACTION_NOTES,
                'transaction_trust_accounts' => RE_TRANSACTION_TABLE_TRANSACTION_TRUST_ACCOUNTS,
                'transaction_members' => RE_TRANSACTION_TABLE_TRANSACTION_MEMBERS,
                'transaction_agent_recruit_source_payments' => RE_TRANSACTION_TABLE_TRANSACTION_AGENT_RECRUIT_SOURCE_PAYMENTS,
                'transaction_disbursement' => RE_TRANSACTION_TABLE_TRANSACTION_DISBURSEMENT,
                'transaction_disbursement_agents_commission' => RE_TRANSACTION_TABLE_TRANSACTION_DISBURSEMENT_AGENTS_COMMISSION,
                'transaction_disbursement_cap_item' => RE_TRANSACTION_TABLE_TRANSACTION_DISBURSEMENT_CAP_ITEM,
                'transaction_disbursement_item' => RE_TRANSACTION_TABLE_TRANSACTION_DISBURSEMENT_ITEM,
                'transaction_disbursement_commission_plan_cap' => RE_TRANSACTION_TABLE_TRANSACTION_DISBURSEMENT_COMMISSION_PLAN_CAP,
                'property_types' => RE_TRANSACTION_TABLE_PROPERTY_TYPES,
                // 'closing_vendors' => RE_TRANSACTION_TABLE_CLOSING_VENDORS,
                'co_brokes' => RE_TRANSACTION_TABLE_CO_BROKES,
                'commission_plans' => RE_TRANSACTION_TABLE_COMMISSION_PLANS,
            ];

            $orgTable = array_map(function ($val) {
                return "`$val`";
            }, array_keys($arrTables));

            $newTable = array_map(function ($val) {
                return "`$val`";
            }, array_values($arrTables));

            foreach ($sqls as $statement) {
                if (trim($statement)) {
                    $statement = str_replace($orgTable, $newTable, $statement) . ";";

                    //file_put_contents(__DIR__. '/sql.log', $statement, FILE_APPEND);
                    $CI->db->query($statement);
                }
            }

            /* Master Data */
            $sqlData = file_get_contents($seederBasePath . "/transaction.sql");

            $sqls = explode(';', $sqlData);

            foreach ($sqls as $statement) {
                if (trim($statement)) {
                    $statement = str_replace($orgTable, $newTable, $statement) . ";";
                    $CI->db->query($statement);
                }
            }
        }
        if (!$CI->db->table_exists(RE_TRANSACTION_TABLE_AGENTS)) {

            /* Create table structure */
            $sqlSchema = file_get_contents($tableBasePath . "/agents_table.sql");

            $sqls = explode(';', $sqlSchema);
            foreach ($sqls as $statement) {
                if (trim($statement)) {
                    //file_put_contents(__DIR__. '/sql.log', $statement, FILE_APPEND);
                    $CI->db->query($statement);
                }
            }

            $CI->db->query('INSERT INTO '.RE_TRANSACTION_TABLE_AGENTS.' (agent_id)
            SELECT staffid FROM '.TABLE_STAFF.'
            WHERE NOT EXISTS (SELECT 1 FROM '.RE_TRANSACTION_TABLE_AGENTS.' WHERE '.RE_TRANSACTION_TABLE_AGENTS.'.agent_id = '.TABLE_STAFF.'.staffid)');
        }
        if (!$CI->db->table_exists(RE_TRANSACTION_TABLE_INTEGRATION_OPTIONS)) {

            /* Create table structure */
            $sqlSchema = file_get_contents($tableBasePath . "/integration_table.sql");

            $sqls = explode(';', $sqlSchema);
            foreach ($sqls as $statement) {
                if (trim($statement)) {
                    //file_put_contents(__DIR__. '/sql.log', $statement, FILE_APPEND);
                    $CI->db->query($statement);
                }
            }
        }
        if (!$CI->db->table_exists(RE_TRANSACTION_TABLE_ONBOARDING_TEMPLATE)) {

            /* Create table structure */
            $sqlSchema = file_get_contents($tableBasePath . "/onboard_table.sql");

            $sqls = explode(';', $sqlSchema);
            foreach ($sqls as $statement) {
                if (trim($statement)) {
                    //file_put_contents(__DIR__. '/sql.log', $statement, FILE_APPEND);
                    $CI->db->query($statement);
                }
            }
        }
        if (!$CI->db->table_exists(RE_TRANSACTION_REPORTS_GROUP)) {

            /* Create table structure */
            $sqlSchema = file_get_contents($tableBasePath . "/reports_table.sql");

            $sqls = explode(';', $sqlSchema);
            foreach ($sqls as $statement) {
                if (trim($statement)) {
                    //file_put_contents(__DIR__. '/sql.log', $statement, FILE_APPEND);
                    $CI->db->query($statement);
                }
            }
        }
        if (!$CI->db->table_exists(RE_TRANSACTION_TABLE_TRANSACTION_ORGANIZATION_OFFICES)) {

            /* Create table structure */
            $sqlSchema = file_get_contents($tableBasePath . "/brg_tables.sql");

            $sqls = explode(';', $sqlSchema);
            foreach ($sqls as $statement) {
                if (trim($statement)) {
                    //file_put_contents(__DIR__. '/sql.log', $statement, FILE_APPEND);
                    $CI->db->query($statement);
                }
            }

            $sqlData = file_get_contents($seederBasePath . "/brg_tables.sql");

            $sqls = explode(';', $sqlData);

            foreach ($sqls as $statement) {
                if (trim($statement)) {
                    $statement = str_replace($orgTable, $newTable, $statement) . ";";
                    $CI->db->query($statement);
                }
            }
        }
    }
}

if (!function_exists('init_re_transaction_install_sequence')) {
    /**
     * Initialize tables content example data for email templates and sms in database
     */
    function init_re_transaction_install_sequence(): void
    {
        /* Create Database Table */
        init_re_transaction_database_tables();

        /* Register Email Template */
        create_email_template('Transaction Note - {property_address}', '<p>Hello {receiver_full_name}</p><p>Note sent by {sender_full_name} ({sender_email}) on {sent_date}:</p><blockquote><p><code>{transaction_note}</code></p></blockquote><p>To reply, log into your account and go to the transaction <a href="{transaction_admin_url}">{property_address}</a> and click Notes.</p>', 're_transaction', 'Transaction Note', 're-transaction-email-transaction-note');
        
        /* Register signup Email Template */
        create_email_template('Signup', '<p>Hello {receiver_full_name}</p><p>Please click on the link below to verify your email address:<br /><br />{verify_email_link}</p><blockquote>
        <p><code></code></p></blockquote><pre>Cheers,The {companyname}  </pre>', 're_transaction', 'Signup', 're-transaction-email-signup');
        
        /* Register resend signup Email Template */
        create_email_template('Signup Email', "<p>Hello {receiver_full_name}</p><p>Your brokerage, INNOVATE REAL ESTATE Inc. has added you to their INNOVATE REAL ESTATE account. You now have access to the agent portal section where you can update your information, upload documents and track your commissions and sales.<br /><br />Your username will be the email address:{receiver_email}</p><pre>Please click the link below to reset your password: {password_reset_link}</pre><pre>If you have any questions, just reply to this message and we'll be happy to help you out.</pre><blockquote><p><code></code></p></blockquote><pre>Cheers,The {companyname}  </pre>", 're_transaction', 'signup Email', 're-transaction-email-resend-signup');
        
        create_email_template('INNOVATE REAL ESTATE - INNOVATE REAL ESTATE Inc. invites you to sign up on INNOVATE REAL ESTATE', "<p>Hello {receiver_full_name}</p>\n<p>Your brokerage, BRG Real Estate Inc., has invited you to complete your onboarding package at INNOVATE REAL ESTATE. <br /><br />{verify_onboarding_link}</p>\n<blockquote>\n<p><code></code></p>\n</blockquote>\n<pre>Cheers,\n\nThe {companyname} \n\</pre>", 're_transaction', 'Agent onboarding', 're-transaction-email-onboarding');
        
        create_email_template('Disbursement created for - {property_address}', "<p>Hello {receiver_full_name}</p>\r\n<p>The disbursement for transaction {property_address} has been created. Please log into your INNOVATE REAL ESTATE account to review your disbursement. If you have any corrections or additional information for the disbursement, please use the notes section and email button to notify the closing department.</p>\r\n<blockquote>\r\n<p><code></code></p>\r\n</blockquote>\r\n<pre>Cheers,\r\n\r\nThe {companyname} \r\n\r\n</pre>", 're_transaction', 'Disbursement created', 're-transaction-email-disbursement-created');

        create_email_template('Disbursement approved for - {property_address}', "<p>Hello {receiver_full_name}</p>\r\n<p>The disbursement for transaction {property_address} has been approved. Please log into your INNOVATE REAL ESTATE account to review your disbursement.</p>\r\n<blockquote>\r\n<p><code></code></p>\r\n</blockquote>\r\n<pre>Cheers,\r\n\r\nThe {companyname} \r\n\r\n</pre>", 're_transaction', 'Disbursement approved', 're-transaction-email-disbursement-approved');
      
        create_email_template('Commission Disbursement for - {property_address}', "<p>Hello {receiver_full_name}</p>\r\n<p>Attached please find the commission disbursement for the property at {property_address}</p>\r\n\r\n<p>This has been sent to you by {sender_full_name} of BRG Real Estate Inc.. If you have questions, please reply to {sender_email} to contact {sender_full_name}.</p>\r\n<pre>Cheers,\r\n\r\nThe {companyname} \r\n\r\n</pre>", 're_transaction', 'Disbursement Paid', 're-transaction-email-disbursement-paid');
        
        create_email_template('Transaction Created for - {property_address}', "<p>Hello {receiver_full_name}</p>\r\n<p>Transaction is created by {sender_full_name} {property_address}</p>\r\n<pre>Cheers,\r\n\r\nThe {companyname} \r\n\r\n</pre>", 're_transaction', 'Transaction Created', 're-transaction-email-transaction-created');
        
        create_email_template('Transaction Document Upload - {property_address}', "<p>Hello {receiver_full_name}</p>\r\n<p>Transaction Document Upload {property_address}</p>\r\n\r\n<pre>Cheers,\r\n\r\nThe {companyname} \r\n\r\n</pre>", 're_transaction', 'Transaction Document Upload', 're-transaction-email-transaction-document-upload');
        
        create_email_template('Disbursement 75 Complete- {property_address}', "<p>Hello {receiver_full_name}</p>\r\n<p>The disbursement for transaction {property_address} has been 75% completed</p>\r\n\r\n<pre>Cheers,\r\n\r\nThe {companyname} \r\n\r\n</pre>", 're_transaction', 'Disbursement is 75% Complete', 're-transaction-email-disbursement-75-complete');
      
        create_email_template('Disbursement Completed- {property_address}', "<p>Hello {receiver_full_name}</p>\r\n<p>The disbursement for transaction {property_address} has been Completed</p>\r\n\r\n<pre>Cheers,\r\n\r\nThe {companyname} \r\n\r\n</pre>", 're_transaction', 'Disbursement is Completed', 're-transaction-email-disbursement-100-complete');

      
        create_email_template('Disbursement is edit after approve- {property_address}', "<p>Hello {receiver_full_name}</p>\r\n<p>The disbursement for transaction {property_address} has been changes after approval</p>\r\n\r\n<pre>Cheers,\r\n\r\nThe {companyname} \r\n\r\n</pre>", 're_transaction', 'Disbursement is edit after approve', 're-transaction-email-disbursement-edit-after-approve');
      
        create_email_template("Transaction agent's task list completed - {property_address}", "<p>Hello {receiver_full_name}</p><p>The Task list for transaction {property_address} has been Completed {sender_full_name} </p><pre>Cheers,The {companyname} </pre>", 're_transaction', "Transaction agent's task list completed", 're-transaction-email-transaction-agent-checklist-completed');
      
        create_email_template("Invoice for - {description}", "<p>Hello {receiver_full_name}</p><p>The invoice for {description}</p><p>Please find attached invoice for your reference</p><pre>Cheers,The {companyname}  </pre>", 're_transaction', "Email invoice agent billing log", 're-transaction-email-invoice-agent-billing-log');

        create_email_template("Login for account", "<p>Hello {receiver_full_name}</p><p>Thank you for signing up</p><p>Please find below attchments for login into your account, Please change your password for your security once you login<br /><br />Login url {admin_url}</p><p>Username {receiver_email}</p><p>Password {password}</p><pre>Cheers,The {companyname}  </pre>", 're_transaction', "Email Agent login credential", 're-transaction-email-agent-onboarding-complete-setup');
      
        create_email_template("Agent completed signup", "<p>Hello {receiver_full_name}</p><p>Agent {sender_full_name} {sender_email} is completed signup process.</p><pre>Cheers,The {companyname}  </pre>", 're_transaction', "Email admin for signup complete by agent", 're-transaction-email-admin-onboarding-complete-setup');

        /* Create required upload folder */
        $path = RE_TRANSACTION_DOCUMENT_FOLDER. '/';
        _maybe_create_upload_path($path);

        $agent_document = RE_TRANSACTION_AGENT_DOCUMENT_FOLDER.'/';
        _maybe_create_upload_path($agent_document);
        $folder_path = RE_TRANSACTION_OFFICE_DOCUMENT_FOLDER_FILE_FOLDER.'/';
        _maybe_create_upload_path($folder_path);
        $onboarding_document_folder_path = RE_TRANSACTION_ONBOARDING_DOCUMENT_FOLDER.'/';
        _maybe_create_upload_path($onboarding_document_folder_path);
        $agent_billing_pdf = RE_TRANSACTION_AGENT_BILLING_PDF.'/';
        _maybe_create_upload_path($agent_billing_pdf);
        $report_email_notification = RE_TRANSACTION_REPORT_EMAIL_NOTIFICATION.'/';
        _maybe_create_upload_path($report_email_notification);
        
        $docusign_webhook_path = RE_TRANSACTION_DOCUSIGN_WEBHOOK_RESPONSE . '/';
        _maybe_create_upload_path($docusign_webhook_path);
        
        $agent_transaction_disbursement_path = RE_TRANSACTION_AGENT_TRANSACTION_DISBURSEMENT . '/';
        _maybe_create_upload_path($agent_transaction_disbursement_path);
    }
}
