<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Template extends AdminController
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model('restoration/template_model');
        $this->load->model('restoration/template_table_model');
        $this->load->model('restoration/category_model');
    }

    public function index()
    {

        if ($this->input->is_ajax_request()) {

            $select = [
                RESTORATION_TABLE_TEMPLATE.'.title as title',
                RESTORATION_TABLE_CATEGORY.'.title as category',
            ];
            
            $where = [];
            // $where[] = 'AND item_type = "' . $itemType . '" ';
            // if($this->input->post('item_title')){
            //     $where[] = 'AND item_title LIKE "%' . $this->input->post('item_title') . '%" ';    
            // }

            $aColumns = $select;
            $aAdditionalSelect = [RESTORATION_TABLE_TEMPLATE.'.id'];
            $sIndexColumn = 'id';
            $sTable = RESTORATION_TABLE_TEMPLATE;
            $join = [];
            $join[] = 'LEFT JOIN '.RESTORATION_TABLE_CATEGORY.' ON '.RESTORATION_TABLE_CATEGORY.'.id='.RESTORATION_TABLE_TEMPLATE.'.category';
            $result = data_tables_init($aColumns, $sIndexColumn, $sTable, $join, $where, $aAdditionalSelect);

            //print_r($result);die;

            $output = $result['output'];
            $rResult = $result['rResult'];

            foreach ($rResult as $aRow) {
                $row = [];
                $rowOption = [];
                $rowOption[] = '<a href="'.admin_url('restoration/template/add_edit/'.$aRow['id']).'" >' . _l('restoration_edit') . '</a>';
                $rowOption[] = '<a href="'.admin_url('restoration/template/builder/'.$aRow['id']).'"  class="text-success">' . _l('restoration_builder') . '</a>';
                $rowOption[] = '<a href="'.admin_url('restoration/template/view/'.$aRow['id']).'"  class="text-success">' . _l('View') . '</a>';
                $rowOption[] = '<a href="!#" onclick="delete_task(\'' . $aRow['id'] . '\'); return false;" class="text-danger">' . _l('restoration_delete') . '</a>';

                $row[] = $aRow['title'];
                $row[] = $aRow['category'];
                $row[] = implode(' | ', $rowOption);
                $output['aaData'][] = $row;
            }

            echo json_encode($output);
            die();
        }


        $data = [];
        $data['title'] = _l('restoration_task');
        $data['icon'] = 'fa-users';
        
        $this->load->view('restoration/template/index', $data);
    }

    public function add_edit(int $id = 0): void
    {
       $id = (int)$id;

        if ($this->input->post()) {

            $data = $this->input->post();
            try {
                $success = true;
                if ($id) {
                    $this->template_model->update($id, ['title' => $data['title'], 'category' => $data['category']]);
                    $template_id = $id;
                    $message = _l('restoration_task') . _l('restoration_updated_successfully');
                } else {
                    $template_id = $this->template_model->add(['title' => $data['title'], 'category' => $data['category']]);
                    $message = _l('restoration_task') . _l('restoration_added_successfully') ;
                }
                if($data['field_label']){
                    foreach ($data['field_label'] as $key => $value) {
                        $template_table_arr = array(
                            "template_id" => $template_id,
                            "field_label" => $value,
                            "field_type" => $data['field_type'][$key],
                            "table_column" => ($data['field_type'][$key]=='table')?$data['table_column'][$key]:NULL,
                            "table_row" => ($data['field_type'][$key]=='table')?$data['table_row'][$key]:NULL,
                            "column_data" => ($data['field_type'][$key]=='table')?json_encode($data['column_data'][$key]):NULL,
                            'is_visible_label' => $data['is_visible_label'][$key] ?? 0,
                        );
                        if(!empty($data['table_id'][$key])){
                            $this->template_table_model->update($data['table_id'][$key], $template_table_arr);
                        }else{
                            $this->template_table_model->add($template_table_arr);
                        }
                    }
                }
            } catch (\Exception $e) {
                $success = false;
                $message = _l('restoration_server_error');
            }

            echo json_encode([
                'success' => $success,
                'message' => $message,
            ]);

            die;
        }

        $data = [];
        if ($id > 0) {
            $data['template'] = $this->template_model->get($id);
            $template_table = $this->template_table_model->all(["template_id" => $id]);
            foreach ($template_table as $key => $value) {
                $template_table[$key]["column_data"] = !is_null($value["column_data"])?json_decode($value["column_data"], true):[];
            }
            $data['template_table'] = $template_table;
            $title = _l('edit') . ' ' . $data['template']->title;
        } else {
            $title = _l('add_new');
        }

        $data['id'] = $id;
        $data['category'] = $this->category_model->all();
        $data['title'] = _l('restoration_task');
        $data['icon'] = 'fa-pencil';
        $this->load->view('template/add_edit', $data);
    }

    function tablecolumn() {
        if ($this->input->post()) {
            $data = [];
            $data['no_of_column'] = $this->input->post('column');
            $data['index'] = $this->input->post('index');
            try {
                $success = true;
                $html = $this->load->view('restoration/template/tablecolumn', $data, true);
                $message = "success";
            } catch (\Exception $e) {
                $success = false;
                $message = _l('restoration_server_error');
            }

            echo json_encode([
                'success' => $success,
                'message' => $message,
                'index' => $data['index'],
                'html' => $html
            ]);

            die;
        }
    }

    function delete($id){
        $id = (int)$id;
        if ($this->input->is_ajax_request() && $id) {
            $success = false;
            $message = _l('restoration_something_went_wrong');
            try {
                $total_rows = $this->template_model->get($id);
                if($total_rows){
                    $this->template_model->delete($id);
                    $success = true;
                    $message = _l('restoration_deleted_successfully', _l('restoration_task'));
                }
            } catch (\Exception $e) {
                $success = false;
                $message = _l('restoration_server_error');
            }
            echo json_encode([
                'success' => $success,
                'message' => $message,
            ]);
            die;
        }
    }

    function builder($id){
        $id = (int)$id;
        if ($this->input->post() && $id) {
            $postdata = $this->input->post();
            $success = false;
            $message = _l('restoration_something_went_wrong');
            try {
                $this->template_table_model->update_value_data($postdata, $_FILES);
                $success = true;
                $message = _l('restoration_updated_successfully', _l('restoration_task'));
                set_alert('success', _l('restoration_updated_successfully', _l('restoration_task')));
            } catch (\Exception $e) {
                $success = false;
                $message = _l('restoration_server_error');
                set_alert('success', _l('restoration_server_error'));
            }
            redirect(admin_url('restoration/template'));
            echo json_encode([
                'success' => $success,
                'message' => $message,
            ]);
            die;
        }
        $template_table = $this->template_table_model->all(["template_id" => $id]);
        foreach ($template_table as $key => $value) {
            $template_table[$key]["column_data"] = !is_null($value["column_data"])?json_decode($value["column_data"], true):[];
            $template_table[$key]["row_data"] = !is_null($value["row_data"])?json_decode($value["row_data"], true):'';
            $template_table[$key]["value_data"] = !is_null($value["value_data"])?json_decode($value["value_data"], true):'';
        }
        $data = [];
        $data['id'] = $id;
        $data['table_id'] = $id;
        $data['title'] = _l('Builder');
        $data['icon'] = 'fa-pencil';
        $data['template_table'] = $template_table;
        $this->load->view('template/builder', $data);
    }

    function view($id){
        $id = (int)$id;
        $template_table = $this->template_table_model->all(["template_id" => $id]);
        foreach ($template_table as $key => $value) {
            $template_table[$key]["column_data"] = !is_null($value["column_data"])?json_decode($value["column_data"], true):[];
            $template_table[$key]["row_data"] = !is_null($value["row_data"])?json_decode($value["row_data"], true):'';
            $template_table[$key]["value_data"] = !is_null($value["value_data"])?json_decode($value["value_data"], true):'';
        }
        $data = [];
        $data['id'] = $id;
        $data['table_id'] = $id;
        $data['title'] = _l('View Template');
        $data['icon'] = 'fa-pencil';
        $data['template_table'] = $template_table;
        $this->load->view('template/view', $data);
    }

    function newcomponent() {
        if ($this->input->post()) {
            $data = $this->input->post();
            try {
                $success = true;
                $html = $this->load->view('restoration/template/newcomponent', $data, true);
                $message = "success";
            } catch (\Exception $e) {
                $success = false;
                $message = _l('restoration_server_error');
            }
            echo json_encode([
                'success' => $success,
                'message' => $message,
                'html' => $html
            ]);

            die;
        }
    }

    function tablecomponent() {
        if ($this->input->post()) {
            $data = [];
            try {
                $success = true;
                $html = $this->load->view('restoration/template/tablecomponent', $data, true);
                $message = "success";
            } catch (\Exception $e) {
                $success = false;
                $message = _l('restoration_server_error');
            }
            echo json_encode([
                'success' => $success,
                'message' => $message,
                'html' => $html
            ]);

            die;
        }
    }

}