<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Client extends ClientsController
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model('restoration/projects_model');
        $this->load->model('currencies_model');
        $this->load->model('restoration/template_model');
        $this->load->model('restoration/template_table_model');
        $this->load->model('restoration/task_model');
        $this->load->model('restoration/task_template_table_model');
        $this->load->model('restoration/imagecategory_model');
        $this->load->model('restoration/filecategory_model');
        $this->load->helper('date');
    }

    public function index()
    {
        $client_id = get_client_user_id();
        $data['projects'] = $this->projects_model->get_projects_by_client($client_id);
        $data['title'] = _l('restoration_projects');

        $this->data($data);
        $this->view('restoration/client/index'); // Make sure this view exists
        $this->layout();
    }

    public function project($id)
    {
        $client_id = get_client_user_id();

        $project = $this->projects_model->get($id);

        if (!$project || $project->clientid != $client_id) {
            show_404();
        }

        $data['project'] = $project;

        $group = $this->input->get('group') ?: 'project_overview';
        $group = str_replace('#', '', $group); // Clean up URL hash

        $tabs = [
            'project_overview' => [
                'slug' => 'project_overview',
                'name' => _l('project_overview'),
                'icon' => 'fa fa-th',
                'view' => 'restoration/client/project_overview',
            ],
            'project_tasks' => [
                'slug' => 'project_tasks',
                'name' => _l('tasks'),
                'icon' => 'fa-regular fa-check-circle',
                'view' => 'restoration/client/project_tasks',
            ],
            'project_images' => [
                'slug' => 'project_images',
                'name' => _l('Photos'),
                'icon' => 'fa-solid fa-image',
                'view' => 'restoration/client/project_images',
            ],
            'project_files' => [
                'slug' => 'project_files',
                'name' => _l('Documents'),
                'icon' => 'fa-solid fa-file',
                'view' => 'restoration/client/project_files',
            ],
            'project_report' => [
                'slug' => 'project_report',
                'name' => _l('Reports'),
                'icon' => 'fa-regular fa-note-sticky',
                'view' => 'restoration/client/project_report',
            ],
            'project_notes' => [
                'slug' => 'project_notes',
                'name' => _l('Conclusion'),
                'icon' => 'fa-regular fa-note-sticky',
                'view' => 'restoration/client/project_notes',
            ],
        ];

        if (!isset($tabs[$group])) {
            show_404();
        }

        $data['tabs'] = $tabs;
        $data['tab'] = $tabs[$group];

        // Load tab-specific data
        switch ($group) {
            case 'project_tasks':
                $data['project']->tasks = $this->task_model->get_tasks_by_project($id); // Ensure this function exists
                break;

            case 'project_images':
                $data['project']->images = $this->imagecategory_model->get_by_project($id); // Ensure this function exists
                break;

            case 'project_files':
                $data['project']->files = $this->filecategory_model->get_by_project($id); // Ensure this function exists
                break;

            case 'project_report':

                $tasks = $this->task_model->all([
                    'project_id' => $id,
                    'client_report' => 1
                ]);

                foreach ($tasks as &$task) {
                    $tables = $this->task_template_table_model->all(['task_id' => $task['id']]);
                    foreach ($tables as &$table) {
                        $table['column_data'] = json_decode($table['column_data'], true);
                        $table['row_data'] = json_decode($table['row_data'], true);
                        $table['value_data'] = json_decode($table['value_data'], true);
                    }
                    $task['template_table'] = $tables;
                }

                $data['tasks'] = $tasks;
                break;

            case 'project_notes':
                $data['staff_notes'] = $this->projects_model->get_staff_notes($id);
                break;
        }

        $data['title'] = $project->name;
        $this->data($data);
        $this->view('restoration/client/view');
        $this->layout();
    }
}
