
<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<div id="wrapper">
  <div class="content">
    <div class="row">
      <div class="col-md-12">
        <div class="tw-mb-2">
          <a href="<?= admin_url('deals/deal'); ?>" class="btn btn-primary">
            <i class="fa fa-plus"></i> <?= _l('deal_new'); ?>
          </a>
          <a href="<?= admin_url('deals'); ?>" class="btn btn-default"><?= _l('kan_ban'); ?></a>
        </div>
        <div class="panel_s">
          <div class="panel-body panel-table-full">
            <?php if (count($deals)>0) { ?>
              <table class="table dt-table" data-order-col="0" data-order-type="asc">
                <thead>
                  <tr>
                    <th><?= _l('id'); ?></th>
                    <th><?= _l('deal_name'); ?></th>
                    <th><?= _l('deal_amount'); ?></th>
                    <th><?= _l('deal_pipeline_select'); ?></th>
                    <th><?= _l('deal_stage_select'); ?></th>
                    <th><?= _l('deal_probability'); ?></th>
                    <th><?= _l('deal_expected_close'); ?></th>
                    <th><?= _l('options'); ?></th>
                  </tr>
                </thead>
                <tbody>
                  <?php foreach ($deals as $d) { 
                    $pipeline = array_values(array_filter($pipelines, function($p)use($d){ return (int)$p['id']===(int)$d['pipeline_id']; }));
                    $stageName = '';
                    foreach ($stages as $s) { if ((int)$s['id']===(int)$d['stage_id']) { $stageName = $s['name']; break; } }
                  ?>
                  <tr>
                    <td><?= (int)$d['id']; ?></td>
                    <td><?= e($d['name']); ?></td>
                    <td><?= format_deal_amount($d['amount'], get_base_currency()->id); ?></td>
                    <td><?= isset($pipeline) ? e($pipeline['name']) : '-'; ?></td>
                    <td><?= e($stageName ?: '-'); ?></td>
                    <td><?= is_null($d['probability'])?'-':((int)$d['probability'].'%'); ?></td>
                    <td><?= $d['expected_close_date'] ? _d($d['expected_close_date']) : '-'; ?></td>
                    <td>
                      <a href="<?= admin_url('deals/deal/' . (int)$d['id']); ?>" class="btn btn-sm btn-default"><i class="fa fa-pencil"></i></a>
                      <a href="<?= admin_url('deals/delete_deal/' . (int)$d['id']); ?>" class="btn btn-sm btn-danger _delete"><i class="fa fa-remove"></i></a>
                    </td>
                  </tr>
                  <?php } ?>
                </tbody>
              </table>
            <?php } else { ?>
              <p class="text-muted"><?= _l('not_available'); ?></p>
            <?php } ?>
          </div>
        </div>
      </div>
    </div>
    </div>
</div>
<?php init_tail(); ?>