<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php
$CI = &get_instance();
if (!isset($reasons)) {
    $CI->load->model('deals/deals_model');
    $reasons = $CI->deals_model->get_lost_reasons();
}
$csrf_name = $CI->security->get_csrf_token_name();
$csrf_hash = $CI->security->get_csrf_hash();
?>
<!-- Lost Reasons Management Panel -->
<div class="panel_s">
    <div class="panel-body">
        <div class="">
            <div class="row">
                <div class="col-md-12">
                    <div class="tw-mb-2">
                        <a href="#" onclick="new_lost_reason(); return false;" class="btn btn-primary">
                            <i class="fa-regular fa-plus tw-mr-1"></i>
                            <?= _l('add_lost_reason'); ?>
                        </a>
                    </div>
                    <div class="panel_s">
                        <div class="panel-body panel-table-full">
                            <?php if (count($reasons) > 0) { ?>
                                <table class="table dt-table" data-order-col="1" data-order-type="asc">
                                    <thead>
                                        <th><?= _l('id'); ?></th>
                                        <th><?= _l('lost_reason'); ?></th>
                                        <th><?= _l('options'); ?></th>
                                    </thead>
                                    <tbody>
                                        <?php foreach ($reasons as $reason) { ?>
                                            <tr>
                                                <td><?= e($reason['id']); ?></td>
                                                <td>
                                                    <a href="#" class="tw-font-medium"
                                                        onclick="edit_lost_reason(this,<?= e($reason['id']); ?>); return false;"
                                                        data-name="<?= html_escape($reason['name']); ?>">
                                                        <?= html_entity_decode($reason['name']); ?>
                                                    </a>
                                                </td>
                                                <td>
                                                    <div class="tw-flex tw-items-center tw-space-x-2">
                                                        <a href="#"
                                                            onclick="edit_lost_reason(this,<?= e($reason['id']); ?>); return false;"
                                                            data-name="<?= html_escape($reason['name']); ?>"
                                                            class="tw-text-neutral-500 hover:tw-text-neutral-700 focus:tw-text-neutral-700">
                                                            <i class="fa-regular fa-pen-to-square fa-lg"></i>
                                                        </a>
                                                        <a href="#"
                                                            onclick="delete_lost_reason(<?= e($reason['id']); ?>); return false;"
                                                            class="tw-text-neutral-500 hover:tw-text-neutral-700 focus:tw-text-neutral-700 _delete">
                                                            <i class="fa-regular fa-trash-can fa-lg"></i>
                                                        </a>
                                                    </div>
                                                </td>
                                            </tr>
                                        <?php } ?>
                                    </tbody>
                                </table>
                            <?php } else { ?>
                                <p class="no-margin">
                                    <?= _l('lost_reasons_not_found'); ?>
                                </p>
                            <?php } ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="lost_reason_modal" tabindex="-1" role="dialog">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span
                        aria-hidden="true">&times;</span></button>
                <h4 class="modal-title">
                    <span class="edit-title"><?= _l('edit_lost_reason'); ?></span>
                    <span class="add-title"><?= _l('add_lost_reason'); ?></span>
                </h4>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col-md-12">
                        <div id="additional-lost-reason"></div>
                        <div class="form-group">
                            <label for="lost_reason_name" class="control-label"><?= _l('lost_reason'); ?></label>
                            <input type="text" id="lost_reason_name" name="name" class="form-control">
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal"><?= _l('close'); ?></button>
                <button type="submit" class="btn btn-primary" onclick="manage_lost_reasons();return false;"><?= _l('submit'); ?></button>
            </div>
        </div>
    </div>
</div>

<script>
    var CSRF = { name: '<?= $csrf_name; ?>', value: '<?= $csrf_hash; ?>' };

    function getLostReasonApiUrl() {
        return (typeof admin_url !== 'undefined' ? admin_url : '<?= admin_url(); ?>') + 'deals/lost_reasons';
    }

    function requestLostReason(action, payload, callback) {
        var form = new FormData();
        form.append('action', action);
        Object.keys(payload || {}).forEach(function (k) {
            if (Array.isArray(payload[k])) {
                payload[k].forEach(function(item, idx) {
                    form.append(k + '[]', item);
                });
            } else {
                form.append(k, payload[k]);
            }
        });
        form.append(CSRF.name, CSRF.value);
        fetch(getLostReasonApiUrl(), {
            method: 'POST',
            body: form,
            credentials: 'same-origin'
        })
        .then(function(r) {
            return r.json().catch(function() { return {}; });
        })
        .then(function(data) {
            if (typeof callback === 'function') {
                callback(data.success, data);
            } else {
                if (data.success) {
                    $('#lost_reason_modal').modal('hide');
                } else {
                    alert('Operation failed');
                }
            }
        });
    }

    function manage_lost_reasons() {
        var nameInput = document.getElementById('lost_reason_name');
        var idInput = document.querySelector('#additional-lost-reason input[name="id"]');
        var payload = {};

        if (!nameInput || !nameInput.value.trim()) {
            alert('Name is required.');
            return false;
        }

        payload.name = nameInput.value.trim();
        if (idInput && idInput.value) {
            payload.id = idInput.value;
            payload.action = 'update';
        } else {
            payload.action = 'create';
        }

        requestLostReason(payload.action, payload, function(success) {
            if (success) {
                $('#lost_reason_modal').modal('hide');
                setTimeout(function() {
                    window.location.href = window.location.href;
                }, 100);
            } else {
                alert('Operation failed');
            }
        });
        return false;
    }

    function new_lost_reason() {
        $('#lost_reason_modal').modal('show');
        $('.edit-title').addClass('hide');
        $('.add-title').removeClass('hide');
        $('#additional-lost-reason').html('');
        $('#lost_reason_name').val('');
    }

    function edit_lost_reason(invoker, id) {
        $('#additional-lost-reason').html('<input type="hidden" name="id" value="' + id + '">');
        $('#lost_reason_name').val($(invoker).data('name'));
        $('#lost_reason_modal').modal('show');
        $('.add-title').addClass('hide');
        $('.edit-title').removeClass('hide');
    }

    function delete_lost_reason(id) {
        if (confirm('<?= _l('confirm_action_prompt'); ?>')) {
            requestLostReason('delete', { id: id });
        }
    }

    $(function () {
        $('#lost_reason_modal').on('hidden.bs.modal', function () {
            $('#additional-lost-reason').html('');
            $('#lost_reason_name').val('');
            $('.add-title').removeClass('hide');
            $('.edit-title').removeClass('hide');
        });

        $('#lost_reason_name').on('input', function() {
            if ($(this).val().trim() === '') {
                $(this).addClass('is-invalid');
            } else {
                $(this).removeClass('is-invalid');
            }
        });
    });
</script>