
<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<div class="panel_s">
  <div class="panel-body">
    <?= form_open(admin_url('deals/deal' . (isset($deal) ? '/' . $deal->id : '')), ['id' => 'deal_form']); ?>
    <h4 class="tw-font-semibold tw-text-xl mbot15">
      <?= isset($deal) ? _l('deal_edit') : _l('deal_new'); ?>
    </h4>
    <hr class="hr-panel-heading" />
    
  <div class="row">
      <div class="col-md-6">
        <?= render_input('name', 'deal_name', isset($deal) ? $deal->name : ''); ?>
        <?= render_input('amount', 'deal_amount', isset($deal) ? $deal->amount : '', 'number', ['step' => '0.01']); ?>
        <?php
        $pipeline_selected = isset($deal) ? $deal->pipeline_id : (isset($pipelines['id']) ? $pipelines['id'] : '');
        echo render_select('pipeline_id', $pipelines, ['id', 'name'], 'deal_pipeline_select', $pipeline_selected);
        ?>
        <?php
        echo render_select('stage_id', $stages, ['id', 'name'], 'deal_stage_select', isset($deal) ? $deal->stage_id : '');
        ?>
        <?= render_input('expected_close_date', 'deal_expected_close', isset($deal) ? _d($deal->expected_close_date) : '', 'date'); ?>
        <?php
        $staff = $this->db->select('staffid, firstname, lastname')->get(db_prefix().'staff')->result_array();
        foreach ($staff as &$s) { $s['name'] = $s['firstname'].' '.$s['lastname']; }
        echo render_select('owner_id', $staff, ['staffid', 'name'], 'deal_owner', isset($deal) ? $deal->owner_id : get_staff_user_id());
        ?>
        <?= render_input('probability', 'deal_probability', isset($deal) ? $deal->probability : '', 'number', ['min'=>0, 'max'=>100]); ?>
        <?= render_textarea('description', 'deal_description', isset($deal) ? $deal->description : '', ['rows'=>4]); ?>
      </div>
    </div>

  <div class="text-right">
      <button type="submit" class="btn btn-primary">
        <i class="fa-regular fa-floppy-disk"></i> <?= _l('submit'); ?>
      </button>
      <a href="<?= admin_url('deals/manage'); ?>" class="btn btn-default"><?= _l('cancel'); ?></a>
    </div>
    <?= form_close(); ?>

  </div>
</div>

<script>
  $(function(){
    appValidateForm($('#deal_form'), {name:'required', amount:'required', pipeline_id:'required', stage_id:'required'});
  });
</script>