<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<div class="modal fade" id="convert_deal_to_client_modal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
    <div class="modal-dialog modal-lg" role="document">
        <?php echo form_open('admin/deals/convert_to_customer', ['id' => 'deal_to_client_form']); ?>
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal"><span
                        aria-hidden="true">&times;</span></button>
                <h4 class="modal-title" id="myModalLabel">
                    <?php echo _l('deal_convert_to_client'); ?>
                </h4>
            </div>
            <div class="modal-body">
                <?php echo form_hidden('dealid', $deal->id); ?>
                <?php if (mb_strpos($deal->name, ' ') !== false) {
    $_temp     = explode(' ', $deal->name);
    $firstname = $_temp[0];
    if (isset($_temp[2])) {
        $lastname = $_temp[1] . ' ' . $_temp[2];
    } else {
        $lastname = $_temp[1];
    }
} else {
    $lastname  = '';
    $firstname = $deal->name;
}
           ?>
                <?php echo form_hidden('default_language', $deal->default_language); ?>
                <?php echo render_input('firstname', 'deal_convert_to_client_firstname', $firstname); ?>
                <?php echo render_input('lastname', 'deal_convert_to_client_lastname', $lastname); ?>
                <?php echo render_input('title', 'contact_position', $deal->title); ?>
                <?php echo render_input('email', 'deal_convert_to_email', $deal->email); ?>
                <?php echo render_input('company', 'deal_company', $deal->company); ?>
                <?php echo render_input('phonenumber', 'deal_convert_to_client_phone', $deal->phonenumber); ?>
                <?php echo render_input('website', 'client_website', $deal->website); ?>
                <?php echo render_textarea('address', 'client_address', $deal->address); ?>
                <?php echo render_input('city', 'client_city', $deal->city); ?>
                <?php echo render_input('state', 'client_state', $deal->state); ?>
                <?php
           $countries                = get_all_countries();
           $customer_default_country = get_option('customer_default_country');
           $selected                 = ($deal->country != 0 ? $deal->country : $customer_default_country);
           echo render_select('country', $countries, [ 'country_id', [ 'short_name']], 'clients_country', $selected, ['data-none-selected-text' => _l('dropdown_non_selected_tex')]);
           ?>
                <?php echo render_input('zip', 'clients_zip', $deal->zip); ?>
                <?php
           $not_mergable_customer_fields = ['userid', 'datecreated', 'dealid', 'default_language', 'default_currency', 'active'];
           $not_mergable_contact_fields  = ['id', 'userid', 'datecreated', 'is_primary', 'password', 'new_pass_key', 'new_pass_key_requested', 'last_ip', 'last_login', 'last_password_change', 'active', 'profile_image', 'direction'];
           $customer_fields              = $this->db->list_fields(db_prefix() . 'clients');
           $contact_fields               = $this->db->list_fields(db_prefix() . 'contacts');
           $custom_fields                = get_custom_fields('deals');
           $found_custom_fields          = false;
           foreach ($custom_fields as $field) {
               $value = get_custom_field_value($deal->id, $field['id'], 'deals');
               if ($value == '') {
                   continue;
               }
               $found_custom_fields = true;
           }
        if ($found_custom_fields == true) {
            echo '<h4 class="bold text-center mtop30">' . _l('copy_custom_fields_convert_to_customer') . '</h4><hr />';
        }
      foreach ($custom_fields as $field) {
          $value = get_custom_field_value($deal->id, $field['id'], 'deals');
          if ($value == '') {
              continue;
          } ?>
                <p class="bold text-info"><?php echo e($field['name']); ?> (<?php echo $value; ?>)</p>
                <hr />
                <p class="bold no-margin"><?php echo _l('deals_merge_customer'); ?></p>
                <div class="radio radio-primary">
                    <input type="radio" data-field-id="<?php echo e($field['id']); ?>" id="m_1_<?php echo e($field['id']); ?>"
                        class="include_deals_custom_fields" checked
                        name="include_deals_custom_fields[<?php echo e($field['id']); ?>]" value="1">
                    <label for="m_1_<?php echo e($field['id']); ?>" class="bold">
                        <span data-toggle="tooltip"
                            data-title="<?php echo _l('copy_custom_fields_convert_to_customer_help'); ?>"><i
                                class="fa fa-info-circle"></i></span> <?php echo _l('deal_merge_custom_field'); ?>
                    </label>
                </div>
                <div class="radio radio-primary">
                    <input type="radio" data-field-id="<?php echo e($field['id']); ?>" id="m_2_<?php echo e($field['id']); ?>"
                        class="include_deals_custom_fields"
                        name="include_deals_custom_fields[<?php echo e($field['id']); ?>]" value="2">
                    <label for="m_2_<?php echo e($field['id']); ?>" class="bold">
                        <?php echo _l('deal_merge_custom_field_existing'); ?>
                    </label>
                </div>
                <div class="hide" id="merge_db_field_<?php echo e($field['id']); ?>">
                    <hr />
                    <select name="merge_db_fields[<?php echo e($field['id']); ?>]" class="selectpicker" data-width="100%"
                        data-none-selected-text="<?php echo _l('dropdown_non_selected_tex'); ?>">
                        <option value=""></option>
                        <?php foreach ($customer_fields as $c_field) {
              if (!in_array($c_field, $not_mergable_customer_fields)) {
                  echo '<option value="' . $c_field . '">' . str_replace('_', ' ', ucfirst($c_field)) . '</option>';
              }
          } ?>
                    </select>
                    <hr />
                </div>
                <p class="bold"><?php echo _l('deals_merge_contact'); ?></p>
                <div class="radio radio-primary">
                    <input type="radio" data-field-id="<?php echo e($field['id']); ?>" id="m_3_<?php echo e($field['id']); ?>"
                        class="include_deals_custom_fields"
                        name="include_deals_custom_fields[<?php echo e($field['id']); ?>]" value="3">
                    <label for="m_3_<?php echo e($field['id']); ?>" class="bold">
                        <?php echo _l('deals_merge_as_contact_field'); ?>
                    </label>
                </div>
                <div class="radio radio-primary">
                    <input type="radio" data-field-id="<?php echo e($field['id']); ?>" id="m_4_<?php echo e($field['id']); ?>"
                        class="include_deals_custom_fields"
                        name="include_deals_custom_fields[<?php echo e($field['id']); ?>]" value="4">
                    <label for="m_4_<?php echo e($field['id']); ?>" class="bold">
                        <span data-toggle="tooltip"
                            data-title="<?php echo _l('copy_custom_fields_convert_to_customer_help'); ?>"><i
                                class="fa fa-info-circle"></i></span>
                        <?php echo _l('deal_merge_custom_field'); ?>
                    </label>
                </div>
                <div class="hide" id="merge_db_contact_field_<?php echo e($field['id']); ?>">
                    <hr />
                    <select name="merge_db_contact_fields[<?php echo e($field['id']); ?>]" class="selectpicker"
                        data-width="100%" data-none-selected-text="<?php echo _l('dropdown_non_selected_tex'); ?>">
                        <option value=""></option>
                        <?php foreach ($contact_fields as $c_field) {
              if (!in_array($c_field, $not_mergable_contact_fields)) {
                  echo '<option value="' . $c_field . '">' . str_replace('_', ' ', ucfirst($c_field)) . '</option>';
              }
          } ?>
                    </select>
                </div>
                <hr />
                <div class="radio radio-primary">
                    <input type="radio" data-field-id="<?php echo e($field['id']); ?>" id="m_5_<?php echo e($field['id']); ?>"
                        class="include_deals_custom_fields"
                        name="include_deals_custom_fields[<?php echo e($field['id']); ?>]" value="5">
                    <label for="m_5_<?php echo e($field['id']); ?>" class="bold">
                        <?php echo _l('deal_dont_merge_custom_field'); ?>
                    </label>
                </div>
                <hr />
                <?php
      } ?>
                <?php echo form_hidden('original_deal_email', $deal->email); ?>

                <!-- fake fields are a workaround for chrome autofill getting the wrong fields -->
                <input type="text" class="fake-autofill-field" name="fakeusernameremembered" value='' tabindex="-1" />
                <input type="password" class="fake-autofill-field" name="fakepasswordremembered" value=''
                    tabindex="-1" />

                <div class="client_password_set_wrapper">
                    <label for="password" class="control-label"><?php echo _l('client_password'); ?></label>
                    <div class="input-group">
                        <input type="password" class="form-control password" name="password" autocomplete="off">
                        <span class="input-group-addon tw-border-l-0">
                            <a href="#password" class="show_password"
                                onclick="showPassword('password');return false;"><i class="fa fa-eye"></i></a>
                        </span>
                        <span class="input-group-addon">
                            <a href="#" class="generate_password" onclick="generatePassword(this);return false;"><i
                                    class="fa fa-refresh"></i></a>
                        </span>
                    </div>
                </div>
                <?php if (is_email_template_active('contact-set-password')) { ?>
                <div class="checkbox checkbox-primary">
                    <input type="checkbox" name="send_set_password_email" id="send_set_password_email">
                    <label for="send_set_password_email">
                        <?php echo _l('client_send_set_password_email'); ?>
                    </label>
                </div>
                <?php } ?>
                <?php if (is_email_template_active('new-client-created')) { ?>
                <div class="checkbox checkbox-primary">
                    <input type="checkbox" name="donotsendwelcomeemail" id="donotsendwelcomeemail">
                    <label for="donotsendwelcomeemail"><?php echo _l('client_do_not_send_welcome_email'); ?></label>
                </div>
                <?php } ?>
                <?php if (total_rows(db_prefix() . 'deals_notes', ['rel_id' => $deal->id]) > 0) { ?>
                <div class="checkbox checkbox-primary">
                    <input type="checkbox" name="transfer_notes" id="transfer_notes">
                    <label for="transfer_notes"><?php echo _l('transfer_deal_notes_to_customer'); ?></label>
                </div>
                <?php } ?>
                <?php if (is_gdpr() && get_option('gdpr_enable_consent_for_contacts') == '1' && count($purposes) > 0) { ?>
                <div class="checkbox checkbox-primary">
                    <input type="checkbox" name="transfer_consent" id="transfer_consent">
                    <label for="transfer_consent"><?php echo _l('transfer_consent'); ?></label>
                </div>
                <?php } ?>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default"
                    onclick="init_deal(<?php echo e($deal->id); ?>); return false;"
                    data-dismiss="modal"><?php echo _l('back_to_deal'); ?></button>
                <button type="submit" data-form="#deal_to_client_form" autocomplete="off"
                    data-loading-text="<?php echo _l('wait_text'); ?>"
                    class="btn btn-primary"><?php echo _l('submit'); ?></button>
            </div>
        </div>
        <?php echo form_close(); ?>
    </div>
</div>
<script>
validate_deal_convert_to_client_form();
init_selectpicker();
</script>
