<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php
// Defensive: Ensure $deal is an array
if (!is_array($deal)) {
    // Try to decode if it's a JSON string
    if (is_string($deal)) {
        $decoded = json_decode($deal, true);
        if (json_last_error() === JSON_ERROR_NONE && is_array($decoded)) {
            $deal = $decoded;
        } else {
            // Fallback: show error and skip rendering
            echo '<li class="deal-kan-ban"><div class="panel-body text-danger">' . _l('error_invalid_deal_data') . '</div></li>';
            return;
        }
    } else {
        echo '<li class="deal-kan-ban"><div class="panel-body text-danger">' . _l('error_invalid_deal_data') . '</div></li>';
        return;
    }
}
?>
<style>
/* Card height is fixed in collapsed view, but expands to fit content in expanded view */
.deal-kan-ban {
    min-height: 120px;
    max-height: 120px;
    height: 120px;
    position: relative;
    overflow: hidden;
    background: #fff;
    border-radius: 4px;
    box-shadow: 0 1px 2px rgba(0,0,0,0.03);
    transition: box-shadow 0.15s, max-height 0.2s, min-height 0.2s, height 0.2s;
}
.deal-kan-ban.expanded {
    min-height: 220px;
    max-height: 9999px;
    height: auto;
    overflow: visible;
    z-index: 10;
}
.deal-kan-ban:hover,
.deal-kan-ban:focus-within {
    box-shadow: 0 2px 8px rgba(0,0,0,0.08);
}
.deal-kan-ban .row-options {
    opacity: 0;
    pointer-events: none;
    position: absolute;
    right: 12px;
    bottom: 10px;
    background: rgba(255,255,255,0.95);
    z-index: 2;
    transition: opacity 0.15s;
}
.deal-kan-ban:hover .row-options,
.deal-kan-ban:focus-within .row-options {
    opacity: 1;
    pointer-events: auto;
}
.deal-kan-ban .row-options > * {
    white-space: nowrap;
}
.deal-kan-ban .panel-body {
    height: 100%;
    min-height: 100%;
    display: flex;
    flex-direction: column;
    justify-content: flex-start;
    padding-bottom: 32px;
    position: relative;
}
.deal-kan-ban .deal-card-collapsed {
    overflow: hidden;
    text-overflow: ellipsis;
    white-space: normal;
}
.deal-kan-ban .deal-card-expanded {
    overflow: visible;
    text-overflow: initial;
    white-space: normal;
}
</style>
<li class="deal-kan-ban mb-2" data-deal-id="<?php echo isset($deal['id']) ? e($deal['id']) : ''; ?>" >
    <div class="panel-body">
        <div class="tw-flex tw-justify-between tw-items-center">
            <h5 class="tw-font-semibold tw-mb-1">
                <a href="<?php echo admin_url('deals/view/' . (isset($deal['id']) ? $deal['id'] : '')); ?>"
                    class="tw-text-neutral-800 hover:tw-text-neutral-900">
                    <?php echo isset($deal['name']) ? html_entity_decode($deal['name']) : '-'; ?>
                </a>
            </h5>
            <span class="label label-<?php
            $status = isset($deal['status_final']) ? $deal['status_final'] : '';
            echo ($status == 'won' ? 'success' : ($status == 'lost' ? 'danger' : 'default'));
            ?>">
                <?php echo ucfirst($status); ?>
            </span>
            <button type="button" class="btn btn-xs btn-default tw-ml-2 deal-maximise-btn"
                title="<?php echo _l('expand'); ?>" onclick="toggleDealCardDetails(this)">
                <i class="fa fa-expand"></i>
            </button>
        </div>
        <!-- Collapsed view: Only show name, amount, expected close date -->
        <div class="deal-card-collapsed tw-text-sm tw-text-neutral-600">
            <p>
                <strong><?php echo _l('deal_value'); ?>:</strong>
                <?php
                $deal_value = isset($deal['deal_value']) ? (float) $deal['deal_value'] : 0;
                echo app_format_money($deal_value, $base_currency);
                ?>
            </p>
            <?php if (!empty($deal['expected_close_date'])) { ?>
                <p>
                    <strong><?php echo _l('expected_close_date'); ?>:</strong>
                    <?php echo _d($deal['expected_close_date']); ?>
                </p>
            <?php } ?>
        </div>
        <!-- Expanded view: All details, hidden by default -->
        <div class="deal-card-expanded tw-text-sm tw-text-neutral-600" style="display:none;">
            <p><strong><?php echo _l('company'); ?>:</strong>
                <?php echo isset($deal['company']) && $deal['company'] !== '' ? html_entity_decode($deal['company']) : '-'; ?>
            </p>
            <p>
                <strong><?php echo _l('deal_value'); ?>:</strong>
                <?php echo app_format_money($deal_value, $base_currency); ?>
            </p>
            <?php if (!empty($deal['assigned']) && is_array($deal['assigned'])) { ?>
                <p><strong><?php echo _l('assigned_to'); ?>:</strong>
                    <?php echo isset($deal['assigned']['label']) && $deal['assigned']['label'] !== '' ? html_entity_decode($deal['assigned']['label']) : '-'; ?>
                </p>
            <?php } ?>
            <?php if (!empty($deal['expected_close_date'])) { ?>
                <p><strong><?php echo _l('expected_close_date'); ?>:</strong>
                    <?php echo _d($deal['expected_close_date']); ?>
                </p>
            <?php } ?>
            <?php if (!empty($deal['tags'])) { ?>
                <p><strong><?php echo _l('tags'); ?>:</strong>
                    <?php
                    $tags = is_array($deal['tags']) ? $deal['tags'] : explode(',', $deal['tags']);
                    foreach ($tags as $tag) {
                        $tag = trim($tag);
                        if ($tag) {
                            echo '<span class="label label-info tw-mr-1">' . html_entity_decode($tag) . '</span>';
                        }
                    }
                    ?>
                </p>
            <?php } ?>
            <?php
            // Defensive: business_category and source may be string or array
            if (!empty($deal['business_category'])) {
                $bc = $deal['business_category'];
                $bc_name = is_array($bc) ? (isset($bc['name']) ? $bc['name'] : '-') : $bc;
                ?>
                <p><strong><?php echo _l('business_category'); ?>:</strong>
                    <?php echo html_entity_decode($bc_name ?: '-'); ?>
                </p>
            <?php } ?>
            <?php
            if (!empty($deal['source'])) {
                $src = $deal['source'];
                $src_name = is_array($src) ? (isset($src['name']) ? $src['name'] : '-') : $src;
                ?>
                <p><strong><?php echo _l('source'); ?>:</strong>
                    <?php echo html_entity_decode($src_name ?: '-'); ?>
                </p>
            <?php } ?>
            <p><strong><?php echo _l('dateadded'); ?>:</strong>
                <?php echo isset($deal['dateadded']) ? _dt($deal['dateadded']) : '-'; ?>
            </p>
        </div>
        <div class="row-options tw-mt-2 tw-text-right">
            <a href="<?php echo admin_url('deals/view/' . (isset($deal['id']) ? $deal['id'] : '')); ?>">
                <?php echo _l('view'); ?>
            </a>
            <span> | </span>
            <a href="<?php echo admin_url('deals/edit/' . (isset($deal['id']) ? $deal['id'] : '')); ?>">
                <?php echo _l('edit'); ?>
            </a>
            <span> | </span>
            <a href="<?php echo admin_url('deals/delete/' . (isset($deal['id']) ? $deal['id'] : '')); ?>"
                class="text-danger _delete">
                <?php echo _l('delete'); ?>
            </a>
        </div>
    </div>
</li>
<script>
    function toggleDealCardDetails(btn) {
        var $li = $(btn).closest('.deal-kan-ban');
        var $panel = $li.find('.panel-body');
        var $collapsed = $panel.find('.deal-card-collapsed');
        var $expanded = $panel.find('.deal-card-expanded');
        var $icon = $(btn).find('i');
        if ($expanded.is(':visible')) {
            $expanded.hide();
            $collapsed.show();
            $li.removeClass('expanded');
            $icon.removeClass('fa-compress').addClass('fa-expand');
        } else {
            $collapsed.hide();
            $expanded.show();
            $li.addClass('expanded');
            $icon.removeClass('fa-expand').addClass('fa-compress');
        }
    }
</script>