<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>

<div class="panel_s">
  <div class="panel-body">
    <h4 class="no-margin">
      <?php echo _l('team_group_report'); ?>
    </h4>
    <hr class="hr-panel-heading" />

    <?php if (count($groups) > 0) { ?>
      <div class="table-responsive">
        <table class="table table-striped table-team-group-report">
          <thead>
            <tr>
              <th><?php echo _l('id'); ?></th>
              <th><?php echo _l('group_name'); ?></th>
              <th><?php echo _l('managers'); ?></th>
              <th><?php echo _l('team_leaders'); ?></th>
              <th><?php echo _l('status'); ?></th>
              <th><?php echo _l('sub_groups_count'); ?></th>
            </tr>
          </thead>
          <tbody>
            <?php foreach ($groups as $group) { ?>
              <tr>
                <td><?php echo $group['id']; ?></td>
                <td><?php echo $group['group_name']; ?></td>
                <td>
                  <?php
                    foreach (explode(',', $group['managers']) as $id) {
                      echo '<span class="label label-success">' . get_staff_full_name($id) . '</span> ';
                    }
                  ?>
                </td>
                <td>
                  <?php
                    foreach (explode(',', $group['team_leaders']) as $id) {
                      echo '<span class="label label-info">' . get_staff_full_name($id) . '</span> ';
                    }
                  ?>
                </td>
                <td><?php echo $group['status']; ?></td>
                <td>
                  <?php
                    echo total_rows(db_prefix() . 'team_sub_groups', ['group_id' => $group['id']]);
                  ?>
                </td>
              </tr>
            <?php } ?>
          </tbody>
        </table>
      </div>
    <?php } else { ?>
      <p class="text-danger"><?php echo _l('no_team_groups_found'); ?></p>
    <?php } ?>
  </div>
</div>
