<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>

<div class="panel_s">
  <div class="panel-body">
    <h4 class="no-margin">
      <?php echo _l('kpi_report_of_team'); ?>
    </h4>
    <hr class="hr-panel-heading" />

    <?php if (!empty($kpi_data)) { ?>
      <div class="table-responsive">
        <table class="table table-striped table-kpi-report">
          <thead>
            <tr>
              <th><?php echo _l('group_name'); ?></th>
              <th><?php echo _l('sub_group_name'); ?></th>
              <th><?php echo _l('employee_name'); ?></th>
              <th><?php echo _l('kpi_score'); ?></th>
              <th><?php echo _l('kpi_rating'); ?></th>
            </tr>
          </thead>
          <tbody>
            <?php foreach ($kpi_data as $row) { ?>
              <tr>
                <td><?php echo $row['group_name']; ?></td>
                <td><?php echo $row['sub_group_name']; ?></td>
                <td><?php echo get_staff_full_name($row['staff_id']); ?></td>
                <td><?php echo $row['kpi_score']; ?></td>
                <td>
                  <?php
                    if ($row['kpi_score'] >= 90) {
                      echo '<span class="label label-success">' . _l('excellent') . '</span>';
                    } elseif ($row['kpi_score'] >= 75) {
                      echo '<span class="label label-info">' . _l('good') . '</span>';
                    } elseif ($row['kpi_score'] >= 50) {
                      echo '<span class="label label-warning">' . _l('average') . '</span>';
                    } else {
                      echo '<span class="label label-danger">' . _l('poor') . '</span>';
                    }
                  ?>
                </td>
              </tr>
            <?php } ?>
          </tbody>
        </table>
      </div>
    <?php } else { ?>
      <p class="text-danger"><?php echo _l('no_kpi_data_found'); ?></p>
    <?php } ?>
  </div>
</div>
