<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<div class="panel_s">
  <div class="panel-body">
    <h4 class="no-margin"><?php echo _l('team_group_list'); ?></h4>
    <hr class="hr-panel-heading" />

    <a href="<?php echo admin_url('team_group/create'); ?>" class="btn btn-primary mbot15">
      <i class="fa fa-plus"></i> <?php echo _l('create_team_group'); ?>
    </a>

    <div class="table-responsive">
      <table class="table table-team-group">
        <thead>
          <tr>
            <th><?php echo _l('group_name'); ?></th>
            <th><?php echo _l('managers'); ?></th>
            <th><?php echo _l('team_leaders'); ?></th>
            <th><?php echo _l('status'); ?></th>
            <th><?php echo _l('options'); ?></th>
          </tr>
        </thead>
        <tbody>
          <?php foreach ($groups as $group) { ?>
            <tr>
              <td><?php echo e($group['name']); ?></td>
              <td><?php echo render_staff_names($group['managers']); ?></td>
              <td><?php echo render_staff_names($group['team_leaders']); ?></td>
              <td>
                <span class="label label-<?php echo $group['status'] == 'Active' ? 'success' : 'danger'; ?>">
                  <?php echo $group['status']; ?>
                </span>
              </td>
              <td>
                <a href="<?php echo admin_url('team_group/edit/' . $group['id']); ?>" class="btn btn-default btn-icon"><i class="fa fa-pencil"></i></a>
                <a href="<?php echo admin_url('team_group/delete/' . $group['id']); ?>" class="btn btn-danger btn-icon _delete"><i class="fa fa-remove"></i></a>
              </td>
            </tr>
          <?php } ?>
        </tbody>
      </table>
    </div>
  </div>
</div>
