<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>

<div class="panel_s">
  <div class="panel-body">
    <h4 class="no-margin">
      <?php echo isset($sub_group) ? _l('edit_sub_group') : _l('create_sub_group'); ?>
    </h4>
    <hr class="hr-panel-heading" />

    <?php echo form_open(admin_url('team_group/save_sub_group'), ['id' => 'sub-group-form']); ?>

    <?php echo form_hidden('id', isset($sub_group) ? $sub_group['id'] : ''); ?>

    <div class="form-group">
      <label for="sub_group_name"><?php echo _l('sub_group_name'); ?></label>
      <input type="text" name="sub_group_name" class="form-control" value="<?php echo isset($sub_group) ? e($sub_group['sub_group_name']) : ''; ?>" required>
    </div>

    <div class="form-group">
      <label for="employees"><?php echo _l('select_employees'); ?></label>
      <select name="employees[]" class="form-control selectpicker" multiple data-live-search="true" required>
        <?php foreach ($staff as $member) { ?>
          <option value="<?php echo $member['staffid']; ?>" <?php echo (isset($sub_group) && in_array($member['staffid'], explode(',', $sub_group['employees']))) ? 'selected' : ''; ?>>
            <?php echo get_staff_full_name($member['staffid']); ?>
          </option>
        <?php } ?>
      </select>
    </div>

    <div class="form-group">
      <label for="status"><?php echo _l('status'); ?></label>
      <select name="status" class="form-control selectpicker" required>
        <option value="Active" <?php echo (isset($sub_group) && $sub_group['status'] == 'Active') ? 'selected' : ''; ?>><?php echo _l('active'); ?></option>
        <option value="Inactive" <?php echo (isset($sub_group) && $sub_group['status'] == 'Inactive') ? 'selected' : ''; ?>><?php echo _l('inactive'); ?></option>
      </select>
    </div>

    <button type="submit" class="btn btn-primary"><?php echo _l('submit'); ?></button>
    <a href="<?php echo admin_url('team_group/sub_groups'); ?>" class="btn btn-default"><?php echo _l('cancel'); ?></a>

    <?php echo form_close(); ?>
  </div>
</div>
