<?php

defined('BASEPATH') or exit('No direct script access allowed');

/*
Module Name: Team Group
Description: Module to manage staff grouping like team groups and sub groups.
Version: 1.0.0
Author: CODESYNERGIX
Author URI: https://codesynergix.com
Requires at least: 2.3.*
*/

define('TEAM_GROUP_MODULE_NAME', 'team_group');

$CI = &get_instance();

// Load helpers, constants, etc.
$CI->load->helper(TEAM_GROUP_MODULE_NAME . '/team_group');

register_activation_hook(TEAM_GROUP_MODULE_NAME, 'team_group_module_activation_hook');
register_language_files(TEAM_GROUP_MODULE_NAME, [TEAM_GROUP_MODULE_NAME]);

function team_group_module_activation_hook()
{
    $CI = &get_instance();
    require_once(__DIR__ . '/install.php');
}

// Add Admin Sidebar Menu
hooks()->add_action('admin_init', 'team_group_module_admin_menu');

function team_group_module_admin_menu()
{
    $CI = &get_instance();

    $CI->app_menu->add_sidebar_menu_item('team-group-main-menu', [
        'name'     => _l('team_group'),
        'icon'     => 'fa fa-users',
        'href'     => 'javascript:void(0);',
        'position' => 25,
    ]);

    $CI->app_menu->add_sidebar_children_item('team-group-main-menu', [
        'slug'     => 'team-group-list',
        'name'     => _l('team_group_list'),
        'href'     => admin_url('team_group'),
        'position' => 1,
    ]);

    $CI->app_menu->add_sidebar_children_item('team-group-main-menu', [
        'slug'     => 'team-group-report',
        'name'     => _l('team_group_report'),
        'href'     => admin_url('team_group/report'),
        'position' => 2,
    ]);

    $CI->app_menu->add_sidebar_children_item('team-group-main-menu', [
        'slug'     => 'kpi-report',
        'name'     => _l('kpi_report_of_team'),
        'href'     => admin_url('team_group/kpi'),
        'position' => 3,
    ]);

    $CI->app_menu->add_sidebar_children_item('team-group-main-menu', [
        'slug'     => 'create-team-group',
        'name'     => _l('create_team_group'),
        'href'     => admin_url('team_group/create_group'),
        'position' => 4,
    ]);
}
