<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Team_group_model extends App_Model
{
    public function __construct()
    {
        parent::__construct();
    }

    // Add new team group
    public function add_group($data)
    {
        $group_data = [
            'group_name' => $data['group_name'],
            'managers'   => handle_multi_staff_field($data['managers']),
            'tls'        => handle_multi_staff_field($data['tls']),
            'status'     => $data['status'],
            'dateadded'  => date('Y-m-d H:i:s'),
            'addedfrom'  => get_staff_user_id(),
        ];

        $this->db->insert(db_prefix() . 'team_groups', $group_data);
        return $this->db->insert_id();
    }

    // Update team group
    public function update_group($id, $data)
    {
        $group_data = [
            'group_name' => $data['group_name'],
            'managers'   => handle_multi_staff_field($data['managers']),
            'tls'        => handle_multi_staff_field($data['tls']),
            'status'     => $data['status'],
        ];

        $this->db->where('id', $id);
        return $this->db->update(db_prefix() . 'team_groups', $group_data);
    }

    // Get single or all groups
    public function get_groups($id = false)
    {
        if ($id) {
            $this->db->where('id', $id);
            return $this->db->get(db_prefix() . 'team_groups')->row();
        }

        return $this->db->get(db_prefix() . 'team_groups')->result();
    }

    // Delete group
    public function delete_group($id)
    {
        $this->db->where('group_id', $id);
        $this->db->delete(db_prefix() . 'team_subgroups'); // delete related subgroups

        $this->db->where('id', $id);
        return $this->db->delete(db_prefix() . 'team_groups');
    }

    // Add new sub group
    public function add_subgroup($data)
    {
        $subgroup_data = [
            'sub_group_name' => $data['sub_group_name'],
            'group_id'       => $data['group_id'],
            'employees'      => handle_multi_staff_field($data['employees']),
            'status'         => $data['status'],
            'dateadded'      => date('Y-m-d H:i:s'),
            'addedfrom'      => get_staff_user_id(),
        ];

        $this->db->insert(db_prefix() . 'team_subgroups', $subgroup_data);
        return $this->db->insert_id();
    }

    // Update sub group
    public function update_subgroup($id, $data)
    {
        $subgroup_data = [
            'sub_group_name' => $data['sub_group_name'],
            'group_id'       => $data['group_id'],
            'employees'      => handle_multi_staff_field($data['employees']),
            'status'         => $data['status'],
        ];

        $this->db->where('id', $id);
        return $this->db->update(db_prefix() . 'team_subgroups', $subgroup_data);
    }

    // Get single or all subgroups
    public function get_subgroups($group_id = false)
    {
        if ($group_id) {
            $this->db->where('group_id', $group_id);
        }

        return $this->db->get(db_prefix() . 'team_subgroups')->result();
    }

    // Delete sub group
    public function delete_subgroup($id)
    {
        $this->db->where('id', $id);
        return $this->db->delete(db_prefix() . 'team_subgroups');
    }
}
