<?php 
defined('BASEPATH') or exit('No direct script access allowed');

$CI = &get_instance();

// Create main team group table
if (!$CI->db->table_exists(db_prefix() . 'team_groups')) {
    $CI->db->query('CREATE TABLE `' . db_prefix() . "team_groups` (
        `id` INT NOT NULL AUTO_INCREMENT,
        `group_name` VARCHAR(255) NOT NULL,
        `manager_ids` TEXT,
        `tl_ids` TEXT,
        `status` ENUM('active','inactive') DEFAULT 'active',
        `created_at` DATETIME DEFAULT CURRENT_TIMESTAMP,
        PRIMARY KEY (`id`)
    ) ENGINE=InnoDB DEFAULT CHARSET=" . $CI->db->char_set . ';');
}

// Create sub group table
if (!$CI->db->table_exists(db_prefix() . 'team_sub_groups')) {
    $CI->db->query('CREATE TABLE `' . db_prefix() . "team_sub_groups` (
        `id` INT NOT NULL AUTO_INCREMENT,
        `team_group_id` INT NOT NULL,
        `sub_group_name` VARCHAR(255) NOT NULL,
        `employee_ids` TEXT,
        `status` ENUM('active','inactive') DEFAULT 'active',
        `created_at` DATETIME DEFAULT CURRENT_TIMESTAMP,
        PRIMARY KEY (`id`),
        FOREIGN KEY (`team_group_id`) REFERENCES `" . db_prefix() . "team_groups`(`id`) ON DELETE CASCADE
    ) ENGINE=InnoDB DEFAULT CHARSET=" . $CI->db->char_set . ';');
}
