<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Team_group extends AdminController
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model('team_group_model');
        $this->load->helper('team_group');
    }

    public function index()
    {
        // Default: Team Group List
        $data['title'] = _l('team_group_list');
        $data['groups'] = $this->team_group_model->get_all_groups();
        $this->load->view('list', $data);
    }

    public function report()
    {
        // Team Group Report
        $data['title'] = _l('team_group_report');
        $data['report_data'] = $this->team_group_model->get_group_reports();
        $this->load->view('report', $data);
    }

    public function kpi_report()
    {
        // KPI Report of Team
        $data['title'] = _l('kpi_report_of_team');
        $data['kpi_data'] = $this->team_group_model->get_kpi_reports();
        $this->load->view('kpi_report', $data);
    }

    public function create()
    {
        $data['title'] = _l('create_team_group');
        $data['staff_members'] = $this->staff_model->get('', ['active' => 1]);

        if ($this->input->post()) {
            $result = $this->team_group_model->add_group($this->input->post());
            if ($result) {
                set_alert('success', _l('added_successfully', _l('team_group')));
                redirect(admin_url('team_group'));
            }
        }

        $this->load->view('create', $data);
    }

    public function add_sub_group($group_id)
    {
        $data['title'] = _l('add_sub_group');
        $data['group_id'] = $group_id;
        $data['staff_members'] = $this->staff_model->get('', ['active' => 1]);

        if ($this->input->post()) {
            $result = $this->team_group_model->add_sub_group($this->input->post());
            if ($result) {
                set_alert('success', _l('added_successfully', _l('sub_group')));
                redirect(admin_url('team_group'));
            }
        }

        $this->load->view('add_sub_group', $data);
    }
}
