<?php

defined('BASEPATH') or exit('No direct script access allowed');

// Table aliases
$sTable = db_prefix() . 'kpi_team_report ktr';
$sIndexColumn = 'id'; // Use the actual column name without alias

// Select columns with alias
$aColumns = [
    'ktr.id as id',
    'ktr.name as name',
    '(SELECT COUNT(id) FROM ' . db_prefix() . 'kpi_form_list WHERE ' . db_prefix() . 'kpi_form_list.form_id = ktr.id) as total_forms',
    'ktr.dateadded as dateadded'
];

// Map aliased columns to their expected keys in the result set
$columnKeys = [
    'ktr.id as id' => 'id',
    'ktr.name as name' => 'name',
    '(SELECT COUNT(id) FROM ' . db_prefix() . 'kpi_form_list WHERE ' . db_prefix() . 'kpi_form_list.form_id = ktr.id) as total_forms' => 'total_forms',
    'ktr.dateadded as dateadded' => 'dateadded'
];

// Logged in user id
$logged_in_user_id = get_staff_user_id();

// Join with team_groups (only needed for non-admin users)
$join = [
    'LEFT JOIN ' . db_prefix() . 'team_groups tg 
        ON JSON_CONTAINS(ktr.team_group_id, CONCAT(\'"\', tg.id, \'"\'))'
];

// Where conditions
$where = [];

// Check if the user is an admin
if (!is_admin()) {
    // Apply filtering for non-admin users
    $where[] = '(JSON_CONTAINS(tg.manager_ids, \'"' . $logged_in_user_id . '"\') 
              OR JSON_CONTAINS(tg.tl_ids, \'"' . $logged_in_user_id . '"\'))';
}

// Apply team_group_id filter if provided
if (!empty($team_group_id)) {
    $team_group_id = $this->db->escape_str($team_group_id); // Sanitize input
    $where[] = "JSON_CONTAINS(ktr.team_group_id, '\"$team_group_id\"')";
}

// Get results
$result = data_tables_init($aColumns, $sIndexColumn, $sTable, $join, $where, ['ktr.form_key', 'ktr.id']);

// Debug: Log the raw result for troubleshooting
log_message('debug', 'data_tables_init result: ' . print_r($result, true));

$output = $result['output'];
$rResult = $result['rResult'];

// Initialize aaData
$output['aaData'] = [];

foreach ($rResult as $aRow) {
    $row = [];

    foreach ($aColumns as $col) {
        // Get the expected key for the aliased column
        $key = $columnKeys[$col] ?? $col;

        // Safely access the key, default to empty string if missing
        $_data = isset($aRow[$key]) ? $aRow[$key] : '';

        // Handle specific columns
        if ($key == 'name') {
            $id = isset($aRow['id']) ? $aRow['id'] : 0;
            $form_key = isset($aRow['form_key']) ? $aRow['form_key'] : '';
            $_data = '<a href="' . admin_url('team_group/form/' . $id) . '" class="tw-font-medium">' . e($_data) . '</a>';
            $_data .= '<div class="row-options">';
            $_data .= '<a href="' . site_url('team_group/wtl/' . $form_key) . '" target="_blank">' . _l('view') . '</a>';
            $_data .= ' | <a href="' . admin_url('team_group/form/' . $id) . '">' . _l('edit') . '</a>';
            $_data .= ' | <a href="' . admin_url('team_group/delete_form/' . $id) . '" class="_delete">' . _l('delete') . '</a>';
            $_data .= '</div>';
        } elseif ($key == 'dateadded') {
            $_data = $_data ? '<span class="text-has-action is-date" data-toggle="tooltip" data-title="' . e(_dt($_data)) . '">' . e(time_ago($_data)) . '</span>' : '';
        }

        $row[] = $_data;
    }

    $row['DT_RowClass'] = 'has-row-options';
    $output['aaData'][] = $row;
}

// Debug: Log the final output
log_message('debug', 'Final output: ' . print_r($output, true));

echo json_encode($output);
