<?php
defined('BASEPATH') or exit('No direct script access allowed');

$CI =& get_instance();
$CI->load->model('staff_model');

$aColumns = [
    db_prefix() . 'team_sub_groups.id as id',
    db_prefix() . 'team_groups.group_name as group_name',
    db_prefix() . 'team_sub_groups.sub_group_name as sub_group_name',
    db_prefix() . 'team_sub_groups.sub_group_manager as sub_group_manager',
    db_prefix() . 'team_sub_groups.tl_ids as tl_ids',
    db_prefix() . 'team_sub_groups.employee_ids as employee_ids',
    db_prefix() . 'team_sub_groups.client as client',
    db_prefix() . 'team_sub_groups.consultant as consultant',
    db_prefix() . 'team_sub_groups.status as status',
    db_prefix() . 'team_sub_groups.created_at as created_at',
];

$sIndexColumn = 'id';
$sTable = db_prefix() . 'team_sub_groups';

$join = [
    'LEFT JOIN ' . db_prefix() . 'team_groups ON ' . db_prefix() . 'team_groups.id = ' . db_prefix() . 'team_sub_groups.team_group_id',
];

$where = [];

//  Only apply filter if NOT admin
if (!is_admin()) {
    $staff_id = get_staff_user_id();

    // Match JSON fields where staff ID is part of sub_group_manager, tl_ids, employee_ids, or consultant
    $staff_id_str = (string) $staff_id;

    $where[] = "AND (
        JSON_CONTAINS(" . db_prefix() . "team_sub_groups.sub_group_manager, '\"$staff_id_str\"')
        OR JSON_CONTAINS(" . db_prefix() . "team_sub_groups.tl_ids, '\"$staff_id_str\"')
        OR JSON_CONTAINS(" . db_prefix() . "team_sub_groups.employee_ids, '\"$staff_id_str\"')
        OR JSON_CONTAINS(" . db_prefix() . "team_sub_groups.consultant, '\"$staff_id_str\"')
    )";
}

$result = data_tables_init($aColumns, $sIndexColumn, $sTable, $join, $where);
$output = $result['output'];
$rResult = $result['rResult'];

foreach ($rResult as $aRow) {
    $row = [];

    $row[] = $aRow['id'];
    $row[] = $aRow['group_name'];
    $row[] = $aRow['sub_group_name'];

    // Sub Group Manager
    $manager_ids = json_decode($aRow['sub_group_manager'] ?: '[]', true);
    $manager_names = [];
    if (!empty($manager_ids)) {
        foreach ($manager_ids as $staff_id) {
            $manager_names[] = get_staff_full_name($staff_id);
        }
    }
    $row[] = implode(', ', $manager_names) ?: '-';

    // Team Leaders
    $tl_ids = json_decode($aRow['tl_ids'] ?: '[]', true);
    $tl_names = [];
    if (!empty($tl_ids)) {
        foreach ($tl_ids as $staff_id) {
            $tl_names[] = get_staff_full_name($staff_id);
        }
    }
    $row[] = implode(', ', $tl_names) ?: '-';

    // Employees
    $employee_ids = json_decode($aRow['employee_ids'] ?: '[]', true);
    $employee_names = [];
    if (!empty($employee_ids)) {
        foreach ($employee_ids as $staff_id) {
            $employee_names[] = get_staff_full_name($staff_id);
        }
    }
    $row[] = implode(', ', $employee_names) ?: '-';

    // Clients
    $client_ids = json_decode($aRow['client'] ?: '[]', true);
    $client_names = [];
    if (!empty($client_ids)) {
        $CI->db->select('company');
        $CI->db->where_in('userid', $client_ids);
        $clients = $CI->db->get(db_prefix() . 'clients')->result_array();
        $client_names = array_column($clients, 'company');
    }
    $row[] = implode(', ', $client_names) ?: '-';

    // Consultant
    $consultant_ids = json_decode($aRow['consultant'] ?: '[]', true);
    $consultant_names = [];
    if (!empty($consultant_ids)) {
        foreach ($consultant_ids as $staff_id) {
            $consultant_names[] = get_staff_full_name($staff_id);
        }
    }
    $row[] = implode(', ', $consultant_names) ?: '-';

    $row[] = ucfirst($aRow['status']);
    $row[] = _dt($aRow['created_at']);

    $row[] = '<a href="' . admin_url('team_group/edit_sub_group/' . $aRow['id']) . '" class="btn btn-sm btn-default"><i class="fa fa-edit"></i></a>
              <a href="' . admin_url('team_group/delete_sub_group/' . $aRow['id']) . '" class="btn btn-sm btn-danger _delete"><i class="fa fa-trash"></i></a>';

    $output['aaData'][] = $row;
}

return $output;
