<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<div id="wrapper">
    <div class="content">
        <div class="row">
            <div class="col-md-12">
				<div class="tw-mb-2" style="display: flex; justify-content: space-between;">
                    <h4 class="tw-font-bold"><?= _l('team_group_report'); ?></h4>
                   <select id="team_group_filter" class="form-control" style="width: 250px;">
                        <option value=""><?php echo _l('all_team_groups'); ?></option>
                        <?php foreach ($team_groups as $group): ?>
                            <option value="<?php echo $group['id']; ?>">
                                <?php echo $group['group_name']; ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div class="panel_s">
                    <div class="panel-body panel-table-full">
<?php
render_datatable([
    _l('id'),
    _l('form_name'),
    _l('Total Submissions'),
    _l('Last Submission Time'),
    _l('team_group_dt_datecreated'),
    _l('Action'),
], 'team-group-form-report');
?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php init_tail(); ?>

<script>
$(function() {
    var table = initDataTable('.table-team-group-form-report', 
        '<?php echo admin_url('team_group/get_report_table_data'); ?>', 
        undefined, undefined, undefined, [0, 'desc']);

    // Handle team group filter change
    $('#team_group_filter').on('change', function() {
        var teamGroupId = $(this).val();
        // Reload DataTable with the selected team_group_id
        table.ajax.url('<?php echo admin_url('team_group/get_report_table_data'); ?>?team_group_id=' + teamGroupId).load();
    });
});
</script>
</body>
</html>
