<?php
defined('BASEPATH') or exit('No direct script access allowed');
?>
<?php init_head(); ?>
<div id="wrapper">
    <div class="content">
        <div class="row">
            <div class="col-md-12">
                <div class="tw-mb-2" style="display: flex; justify-content: space-between; align-items: center;">
                    <h4 class="tw-font-bold"><?= _l('kpi_report_of_individual'); ?></h4>

                    <div style="display: flex; gap: 10px; align-items: center;">
                        <?php if (!empty($forms)): ?>
                            <select id="form_filter" class="form-control" style="width: 250px;">
                                <option value=""><?= _l('select_form'); ?></option>
                                <?php foreach ($forms as $form): ?>
                                    <option 
                                        value="<?= $form['id']; ?>" 
                                        data-form-key="<?= html_escape($form['form_key']); ?>"
                                        <?= ($form['id'] == $current_form_id) ? 'selected' : ''; ?>>
                                        <?= html_escape($form['name']); ?> (<?= _dt($form['dateadded']); ?>)
                                    </option>
                                <?php endforeach; ?>
                            </select>

                            <!-- Add Report Button -->
                            <button id="addReportBtn" class="btn btn-primary" <?= empty($current_form_id) ? 'disabled' : ''; ?>>
                                <i class="fa fa-plus"></i> <?= _l('add_report'); ?>
                            </button>
                        <?php else: ?>
                            <p><?= _l('no_forms_available'); ?></p>
                        <?php endif; ?>
                    </div>
                </div>

                <?php
                $selected_form_name = '';
                if (!empty($forms) && $current_form_id) {
                    foreach ($forms as $form) {
                        if ($form['id'] == $current_form_id) {
                            $selected_form_name = $form['name'];
                            break;
                        }
                    }
                }
                ?>

                <?php if (!empty($thead_columns)): ?>
                    <div class="panel_s">
                        <div class="panel-body panel-table-full">
                            <div class="d-flex justify-content-between align-items-center">
                                <h4 class="no-margin"><?= html_escape($selected_form_name); ?></h4>
                            </div>
                            <hr class="hr-panel-heading" />
                            <?php render_datatable($thead_columns, 'individual-kpi-data'); ?>
                        </div>
                    </div>
                <?php else: ?>
                    <div class="panel_s">
                        <div class="panel-body">
                            <p><?= _l('no_data_available'); ?></p>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<!-- Modal: View Submission -->
<div class="modal fade" id="submissionModal" tabindex="-1" role="dialog" aria-labelledby="submissionModalLabel">
  <div class="modal-dialog modal-lg" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="submissionModalLabel"><?= _l('submission_details'); ?></h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <table class="table table-bordered" id="submissionDetailsTable">
          <tbody></tbody>
        </table>
      </div>
    </div>
  </div>
</div>

<!-- Modal: Add Report (Form Submission) -->
<div class="modal fade" id="addReportModal" tabindex="-1" role="dialog" aria-labelledby="addReportModalLabel">
  <div class="modal-dialog modal-xl" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="addReportModalLabel"><?= _l('add_report'); ?></h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span>&times;</span>
        </button>
      </div>
      <div class="modal-body" style="height: 80vh;">
        <iframe id="reportFormIframe" src="" width="100%" height="100%" frameborder="0" style="border:0;"></iframe>
      </div>
    </div>
  </div>
</div>

<?php init_tail(); ?>
<script>
$(function() {
    var currentFormId = '<?= $current_form_id; ?>';
    var table;

    // Initialize DataTable
    if (currentFormId && $('.table-individual-kpi-data').length) {
        var ajaxUrl = '<?= admin_url("team_group/individual_form_data_table/"); ?>' + currentFormId;
        table = initDataTable('.table-individual-kpi-data', ajaxUrl, undefined, undefined, undefined, [0, 'desc']);
    }

    // Form Filter Change
    $('#form_filter').on('change', function() {
        var formId = $(this).val();
        if (formId) {
            window.location.href = '<?= admin_url("team_group/kpi_report_individual/"); ?>' + formId;
        }
    });

    // View Submission Modal
    $(document).on('click', '.view-submission', function(e) {
        e.preventDefault();
        var id = $(this).data('id');
        $.get('<?= admin_url('team_group/get_submission_details/'); ?>' + id, function(response) {
            var res = JSON.parse(response);
            if (res.error) {
                alert(res.error);
                return;
            }
            var html = '';
            html += '<tr><th>ID</th><td>' + res.id + '</td></tr>';
            html += '<tr><th>Form ID</th><td>' + res.form_id + '</td></tr>';
            html += '<tr><th>Date Added</th><td>' + res.dateadded + '</td></tr>';
            $.each(res.submitted_data || {}, function(key, value) {
                var val = (typeof value === 'object' ? JSON.stringify(value, null, 2) : value);
                html += '<tr><th>' + key + '</th><td style="white-space: pre-wrap;">' + val + '</td></tr>';
            });
            $('#submissionDetailsTable tbody').html(html);
            $('#submissionModal').modal('show');
        });
    });

    // Add Report Button Click
    $('#addReportBtn').on('click', function() {
        var $selected = $('#form_filter option:selected');
        var formId = $selected.val() || '<?= $current_form_id; ?>';
        var formKey = $selected.data('form-key');

        if (!formId || !formKey) {
            alert('<?= _l('please_select_a_form_first'); ?>');
            return;
        }

        // Build the live form URL using form_key
        var formUrl = '<?= site_url("team_group/wtl/"); ?>' + formKey + '?styled=1&from_modal=1';

        $('#reportFormIframe').attr('src', formUrl);
        $('#addReportModal').modal('show');
    });

    // Refresh table when modal closes (after submission)
    $('#addReportModal').on('hidden.bs.modal', function() {
        if (typeof table !== 'undefined') {
            table.DataTable().ajax.reload(null, false);
        }
    });
});
</script>
</body>
</html>
