<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<div id="wrapper">
    <div class="content">
        <div class="row">
            <div class="col-md-12">
               <div class="tw-mb-2" style="display: flex; justify-content: space-between; align-items: center;">
    <?php if (is_admin()) : ?>
        <a href="<?php echo admin_url('team_group/form'); ?>" class="btn btn-primary">
            <i class="fa-regular fa-plus tw-mr-1"></i>
            <?php echo _l('new_form'); ?>
        </a>
    <?php else: ?>
        <div></div> <!-- Empty div to keep spacing -->
    <?php endif; ?>

    <select id="team_group_filter" class="form-control" style="width: 250px;">
        <option value=""><?php echo _l('all_team_groups'); ?></option>
        <?php foreach ($team_groups as $group): ?>
            <option value="<?php echo $group['id']; ?>">
                <?php echo $group['group_name']; ?>
            </option>
        <?php endforeach; ?>
    </select>
</div>

                <div class="panel_s">
                    <div class="panel-body panel-table-full">
                        <?php hooks()->do_action('forms_table_start'); ?>
                        <?php render_datatable([
                              _l('id'),
                              _l('form_name'),
                              _l('total_submissions'),
                              _l('team_group_dt_datecreated'),
                              ], 'web-to-team-group'); ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php init_tail(); ?>
<script>
$(function() {
var table = initDataTable('.table-web-to-team-group', 
        '<?php echo admin_url('team_group/table_kpi_team_report'); ?>', 
        undefined, undefined, undefined, [0, 'desc']);

    // Handle team group filter change
    $('#team_group_filter').on('change', function() {
        var teamGroupId = $(this).val();
        // Reload DataTable with the selected team_group_id
        table.ajax.url('<?php echo admin_url('team_group/table_kpi_team_report'); ?>?team_group_id=' + teamGroupId).load();
    });
});
</script>
</body>

</html>