<?php

defined('BASEPATH') or exit('No direct script access allowed');

/*
Module Name: Team Group
Description: Module to manage staff grouping like team groups and sub groups.
Version: 1.0.0
Author: CODESYNERGIX
Author URI: https://codesynergix.com
Requires at least: 2.3.*
*/

define('TEAM_GROUP_MODULE_NAME', 'team_group');
defined('TEAM_GROUP_ATTACHMENTS_FOLDER') || define('TEAM_GROUP_ATTACHMENTS_FOLDER', 'modules/team_group/uploads/');

$CI = &get_instance();

// Load helpers, constants, etc.
$CI->load->helper(TEAM_GROUP_MODULE_NAME . '/team_group');

register_activation_hook(TEAM_GROUP_MODULE_NAME, 'team_group_module_activation_hook');
register_language_files(TEAM_GROUP_MODULE_NAME, [TEAM_GROUP_MODULE_NAME]);

function team_group_module_activation_hook()
{
    $CI = &get_instance();
    require_once(__DIR__ . '/install.php');
}

// Add Admin Sidebar Menu
hooks()->add_action('admin_init', 'team_group_module_admin_menu');

function team_group_module_admin_menu()
{
    $CI = &get_instance();

    // Main Menu 1: Team 
    $CI->app_menu->add_sidebar_menu_item('team-dashboard-main-menu', [
        'name'     => _l('team_group'), 
        'icon'     => 'fa fa-users',
        'href'     => 'javascript:void(0);',
        'position' => 25,
    ]);
    $CI->app_menu->add_sidebar_children_item('team-dashboard-main-menu', [
        'slug'     => 'team-group-list',
        'name'     => _l('team_group_list'),
        'href'     => admin_url('team_group'),
        'position' => 1,
    ]);

    $CI->app_menu->add_sidebar_children_item('team-dashboard-main-menu', [
        'slug'     => 'team-sub-group-list',
        'name'     => _l('team_sub_group_list'),
        'href'     => admin_url('team_group/team_sub_group'),
        'position' => 2,
    ]);

    // Main Menu 2: KPI 
    $CI->app_menu->add_sidebar_menu_item('kpi-report-main-menu', [
        'name'     => _l('kpi_report'),
        'icon'     => 'fa fa-bar-chart',
        'href'     => 'javascript:void(0);',
        'position' => 26,
    ]);
    $CI->app_menu->add_sidebar_children_item('kpi-report-main-menu', [
        'slug'     => 'kpi-form-list',
        'name'     => _l('kpi_form_list'),
        'href'     => admin_url('team_group/report'),
        'position' => 1,
    ]);

    $CI->app_menu->add_sidebar_children_item('kpi-report-main-menu', [
        'slug'     => 'kpi-report-of-team',
        'name'     => _l('kpi_report_of_team'),
        'href'     => admin_url('team_group/forms'),
        'position' => 2,
    ]);
	
	$CI->app_menu->add_sidebar_children_item('kpi-report-main-menu', [
        'slug'     => 'kpi-report-of-individual',
        'name'     => _l('kpi_report_of_individual'),
        'href'     => admin_url('team_group/kpi_report_individual'),
        'position' => 3,
    ]);
}

