<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Team_group_model extends App_Model
{
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Log KPI activity
     * @param mixed $kpiformid KPI form ID
     * @param string $description Activity description
     * @param boolean $integration Whether this is an integration action (e.g., from CRON)
     * @param string $additional_data Additional serialized data for the activity
     * @param int $custom_activity Whether this is a custom activity (0 or 1)
     * @return mixed Insert ID on success, false on failure
     */
    public function log_kpi_activity($kpiformid, $description, $integration = false, $additional_data = '', $custom_activity = 0)
    {
        $log = [
            'date' => date('Y-m-d H:i:s'),
            'description' => $description,
            'kpiformid' => $kpiformid,
            'staffid' => get_staff_user_id(),
            'additional_data' => $additional_data,
            'full_name' => get_staff_full_name(get_staff_user_id()),
            'custom_activity' => $custom_activity,
        ];

        if ($integration == true) {
            $log['staffid'] = 0;
            $log['full_name'] = '[CRON]';
        }

        $this->db->insert(db_prefix() . 'kpi_activity_log', $log);
        if ($this->db->affected_rows() > 0) {
            return $this->db->insert_id();
        } else {
            log_message('error', 'Insert failed: ' . $this->db->last_query() . ' | Error: ' . $this->db->_error_message());
            return false;
        }
    }

    public function add_group($data, $id = null)
    {
        $group_data = [
            'group_name' => $data['group_name'],
            'manager_ids' => handle_multi_staff_field($data['managers']),
            'tl_ids' => handle_multi_staff_field($data['team_leaders']),
            'status' => $data['status'],
        ];
        if ($id) {
            $this->db->where('id', $id);
            $this->db->update(db_prefix() . 'team_groups', $group_data);
            return $id;
        } else {
            $group_data['created_at'] = date('Y-m-d H:i:s');
            $this->db->insert(db_prefix() . 'team_groups', $group_data);
            return $this->db->insert_id();
        }
    }

    public function update_group($id, $data)
    {
        $group_data = [
            'group_name' => $data['group_name'],
            'manager_ids' => handle_multi_staff_field($data['managers']),
            'tl_ids' => handle_multi_staff_field($data['team_leaders']),
            'status' => $data['status'],
        ];
        $this->db->where('id', $id);
        return $this->db->update(db_prefix() . 'team_groups', $group_data);
    }

    public function get_groups($id = false)
    {
        if ($id) {
            $this->db->where('id', $id);
            return $this->db->get(db_prefix() . 'team_groups')->row();
        }
        return $this->db->get(db_prefix() . 'team_groups')->result();
    }

    public function delete_group($id)
    {
        $this->db->where('id', $id);
        return $this->db->delete(db_prefix() . 'team_groups');
    }

    public function add_subgroup($data)
    {
        $subgroup_data = [
            'sub_group_name' => $data['sub_group_name'],
            'sub_group_manager' => handle_multi_staff_field($data['managers'] ?? []),
            'team_group_id' => $data['group_id'],
            'client' => handle_multi_staff_field($data['clients'] ?? []),
            'consultant' => handle_multi_staff_field($data['consultants'] ?? []),
            'employee_ids' => handle_multi_staff_field($data['employees'] ?? []),
            'tl_ids' => handle_multi_staff_field($data['team_leaders'] ?? []),
            'status' => $data['status'],
            'created_at' => date('Y-m-d H:i:s'),
        ];
        $this->db->insert(db_prefix() . 'team_sub_groups', $subgroup_data);
        if ($this->db->affected_rows() > 0) {
            return $this->db->insert_id();
        } else {
            log_message('error', 'Insert failed: ' . $this->db->last_query() . ' | Error: ' . $this->db->_error_message());
            return false;
        }
    }

    public function update_subgroup($data, $id)
    {
        $subgroup_data = [
            'sub_group_name' => $data['sub_group_name'],
            'team_group_id' => $data['group_id'],
            'employee_ids' => handle_multi_staff_field($data['employees']),
            'tl_ids' => handle_multi_staff_field($data['team_leaders']),
            'sub_group_manager' => handle_multi_staff_field($data['managers']),
            'client' => handle_multi_staff_field($data['clients']),
            'consultant' => handle_multi_staff_field($data['consultants']),
            'status' => $data['status'],
        ];
        $this->db->where('id', $id);
        return $this->db->update(db_prefix() . 'team_sub_groups', $subgroup_data);
    }

    public function get_subgroups($group_id = false)
    {
        if ($group_id) {
            $this->db->where('id', $group_id);
            $group_data = $this->db->get(db_prefix() . 'team_sub_groups')->row();
        }
        return $this->db->get(db_prefix() . 'team_sub_groups')->result();
    }

    public function delete_subgroup($id)
    {
        $this->db->where('id', $id);
        return $this->db->delete(db_prefix() . 'team_sub_groups');
    }

    public function get_all_groups()
    {
        return $this->db->get(db_prefix() . 'team_groups')->result();
    }

    public function get_group_by_id($id)
    {
        return $this->db->where('id', $id)->get(db_prefix() . 'team_groups')->row();
    }

    public function get_all_staff()
    {
        return $this->db->get(db_prefix() . 'staff')->result_array();
    }

    public function team_sub_group()
    {
        $data['title'] = _l('team_sub_group_list');
        $data['sub_groups'] = $this->team_group_model->get_all_groups();
        $this->load->view('sub_group_list', $data);
    }

    public function get_sub_group_by_id($id)
    {
        return $this->db->where('id', $id)->get(db_prefix() . 'team_sub_groups')->row();
    }

    public function get_group_reports()
    {
        return $this->db->get(db_prefix() . 'kpi_team_report')->result();
    }

    public function get_form($where)
    {
        $this->db->where($where);
        $form = $this->db->get(db_prefix() . 'kpi_team_report')->row();
        if ($form) {
            if (isset($form->team_group_id) && !empty($form->team_group_id)) {
                $form->team_group_id = json_decode($form->team_group_id, true);
            } else {
                $form->team_group_id = [];
            }
            if (isset($form->team_sub_groups) && !empty($form->team_sub_groups)) {
                $form->team_sub_groups = json_decode($form->team_sub_groups, true);
            } else {
                $form->team_sub_groups = [];
            }
        }
        return $form;
    }

    public function add_form($data)
    {
        $data = $this->_do_team_web_to_form_responsibles($data);
        $data['success_submit_msg'] = nl2br($data['success_submit_msg']);
        $data['form_key'] = app_generate_hash();
        $data['create_task_on_duplicate'] = (int) isset($data['create_task_on_duplicate']);
        $data['mark_public'] = (int) isset($data['mark_public']);
        if (isset($data['allow_duplicate'])) {
            $data['allow_duplicate'] = 1;
            $data['track_duplicate_field'] = '';
            $data['track_duplicate_field_and'] = '';
            $data['create_task_on_duplicate'] = 0;
        } else {
            $data['allow_duplicate'] = 0;
        }
        if (isset($data['team_group_id']) && is_array($data['team_group_id'])) {
            $data['team_group_id'] = json_encode($data['team_group_id']);
        }
        if (isset($data['team_sub_groups']) && is_array($data['team_sub_groups'])) {
            $data['team_sub_groups'] = json_encode($data['team_sub_groups']);
        }
        $data['dateadded'] = date('Y-m-d H:i:s');
        $this->db->insert(db_prefix() . 'kpi_team_report', $data);
        $insert_id = $this->db->insert_id();
        if ($insert_id) {
            log_activity('New Web to campaign Form Added [' . $data['name'] . ']');
            $this->log_kpi_activity($insert_id, 'not_kpi_activity_form_added');
            return $insert_id;
        }
        return false;
    }

    public function update_form($id, $data)
    {
        $data = $this->_do_team_web_to_form_responsibles($data);
        $data['success_submit_msg'] = nl2br($data['success_submit_msg']);
        $data['create_task_on_duplicate'] = (int) isset($data['create_task_on_duplicate']);
        $data['mark_public'] = (int) isset($data['mark_public']);
        if (isset($data['allow_duplicate'])) {
            $data['allow_duplicate'] = 1;
            $data['track_duplicate_field'] = '';
            $data['track_duplicate_field_and'] = '';
            $data['create_task_on_duplicate'] = 0;
        } else {
            $data['allow_duplicate'] = 0;
        }
        if (isset($data['team_group_id']) && is_array($data['team_group_id'])) {
            $data['team_group_id'] = json_encode($data['team_group_id']);
        }
        if (isset($data['team_sub_groups']) && is_array($data['team_sub_groups'])) {
            $data['team_sub_groups'] = json_encode($data['team_sub_groups']);
        }
        $this->db->where('id', $id);
        $this->db->update(db_prefix() . 'kpi_team_report', $data);
        if ($this->db->affected_rows() > 0) {
            $this->log_kpi_activity($id, 'not_kpi_activity_form_updated');
            return true;
        }
        return false;
    }

    public function delete_form($id)
    {
        $this->db->where('id', $id);
        $this->db->delete(db_prefix() . 'kpi_team_report');
        $this->db->where('from_form_id', $id);
        $this->db->update(db_prefix() . 'campaigns', [
            'from_form_id' => 0,
        ]);
        if ($this->db->affected_rows() > 0) {
            log_activity('campaign Form Deleted [' . $id . ']');
            $this->log_kpi_activity($id, 'not_kpi_activity_form_deleted');
            return true;
        }
        return false;
    }

    private function _do_team_web_to_form_responsibles($data)
    {
        if (isset($data['notify_team_group_imported'])) {
            $data['notify_team_group_imported'] = 1;
        } else {
            $data['notify_team_group_imported'] = 0;
        }
        if ($data['responsible'] == '') {
            $data['responsible'] = 0;
        }
        if ($data['notify_team_group_imported'] != 0) {
            if ($data['notify_type'] == 'specific_staff') {
                if (isset($data['notify_ids_staff'])) {
                    $data['notify_ids'] = serialize($data['notify_ids_staff']);
                    unset($data['notify_ids_staff']);
                } else {
                    $data['notify_ids'] = serialize([]);
                    unset($data['notify_ids_staff']);
                }
                if (isset($data['notify_ids_roles'])) {
                    unset($data['notify_ids_roles']);
                }
            } else {
                if (isset($data['notify_ids_roles'])) {
                    $data['notify_ids'] = serialize($data['notify_ids_roles']);
                    unset($data['notify_ids_roles']);
                } else {
                    $data['notify_ids'] = serialize([]);
                    unset($data['notify_ids_roles']);
                }
                if (isset($data['notify_ids_staff'])) {
                    unset($data['notify_ids_staff']);
                }
            }
        } else {
            $data['notify_ids'] = serialize([]);
            $data['notify_type'] = null;
            if (isset($data['notify_ids_staff'])) {
                unset($data['notify_ids_staff']);
            }
            if (isset($data['notify_ids_roles'])) {
                unset($data['notify_ids_roles']);
            }
        }
        return $data;
    }

    public function log_team_group_activity($team_group_id, $description, $is_form = false, $additional_data = null)
    {
        $this->db->insert(db_prefix() . 'team_group_activity_log', [
            'team_group_id' => $team_group_id,
            'description' => $description,
            'additional_data' => $additional_data,
            'date' => date('Y-m-d H:i:s'),
            'is_form_submission' => $is_form ? 1 : 0,
        ]);
    }

    public function get_form_data_by_report_form_id($team_report_id)
    {
        return $this->db->where('form_id', $team_report_id)->get(db_prefix() . 'kpi_form_list')->result_array();
    }

    public function get_pivoted_form_submissions($form_id)
    {
        $this->db->where('form_id', $form_id);
        $results = $this->db->get(db_prefix() . 'kpi_form_list')->result();
        $columns = [];
        $rows = [];
        foreach ($results as $row) {
            $data = json_decode($row->submitted_data, true) ?? [];
            foreach (array_keys($data) as $key) {
                if (!in_array($key, $columns)) {
                    $columns[] = $key;
                }
            }
            $rows[] = [
                'id' => $row->id,
                'form_id' => $row->form_id,
                'submitted_data' => $data,
                'dateadded' => $row->dateadded,
            ];
        }
        return [
            'columns' => $columns,
            'rows' => $rows,
        ];
    }

    public function get_form_submission_by_id($id)
    {
        $this->db->where('id', $id);
        return $this->db->get(db_prefix() . 'kpi_team_report')->row();
    }

}