<?php 
defined('BASEPATH') or exit('No direct script access allowed');

$CI = &get_instance();

$table_name = db_prefix() . 'team_groups';

// Step 1: Create table if it doesn't exist
if (!$CI->db->table_exists($table_name)) {
    $CI->db->query('CREATE TABLE `' . $table_name . "` (
        `id` INT NOT NULL AUTO_INCREMENT,
        `group_name` VARCHAR(255) NOT NULL,
        `manager_ids` TEXT,
        `tl_ids` TEXT,
        `status` ENUM('active','inactive') DEFAULT 'active',
        `from_form_id` INT(11) NOT NULL DEFAULT 0,
        `created_at` DATETIME DEFAULT CURRENT_TIMESTAMP,
        PRIMARY KEY (`id`)
    ) ENGINE=InnoDB DEFAULT CHARSET=" . $CI->db->char_set . ';');

    log_message('debug', 'Created table ' . $table_name . ' with from_form_id column.');
} else {
    // Step 2: Add from_form_id column if missing
    $column_exists = $CI->db->query("SHOW COLUMNS FROM `$table_name` LIKE 'from_form_id'")->num_rows();
    if ($column_exists == 0) {
        $CI->db->query("ALTER TABLE `$table_name` ADD `from_form_id` INT(11) NOT NULL DEFAULT 0 AFTER `status`");
        log_message('debug', 'Added from_form_id column to existing ' . $table_name);
    } else {
        log_message('debug', 'from_form_id column already exists in ' . $table_name);
    }
}

// Create sub group table
if (!$CI->db->table_exists(db_prefix() . 'team_sub_groups')) {
    $CI->db->query('CREATE TABLE `' . db_prefix() . "team_sub_groups` (
        `id` INT NOT NULL AUTO_INCREMENT,
        `team_group_id` INT NOT NULL,
        `sub_group_name` VARCHAR(255) NOT NULL,
        `employee_ids` TEXT,
		`tl_ids` TEXT,
        `status` ENUM('active','inactive') DEFAULT 'active',
        `created_at` DATETIME DEFAULT CURRENT_TIMESTAMP,
        PRIMARY KEY (`id`),
        FOREIGN KEY (`team_group_id`) REFERENCES `" . db_prefix() . "team_groups`(`id`) ON DELETE CASCADE
    ) ENGINE=InnoDB DEFAULT CHARSET=" . $CI->db->char_set . ';');
}
if (!$CI->db->table_exists(db_prefix() . 'team_group_activity_log')) {
    $CI->db->query('CREATE TABLE `' . db_prefix() . "team_group_activity_log` (
        `id` INT NOT NULL AUTO_INCREMENT,
        `team_group_id` INT NOT NULL,
        `description` TEXT NULL,
        `additional_data` LONGTEXT NULL,
        `date` DATETIME NULL DEFAULT CURRENT_TIMESTAMP,
        `is_form_submission` TINYINT(1) NULL DEFAULT 0,
        PRIMARY KEY (`id`),
        FOREIGN KEY (`team_group_id`) REFERENCES `" . db_prefix() . "team_groups`(`id`) ON DELETE CASCADE
    ) ENGINE=InnoDB DEFAULT CHARSET=" . $CI->db->char_set . ';');
}

if (!$CI->db->table_exists(db_prefix() . 'kpi_team_report')) {
    $CI->db->query('CREATE TABLE `' . db_prefix() . 'kpi_team_report` (
        `id` INT(11) NOT NULL AUTO_INCREMENT,
        `form_key` VARCHAR(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
        `team_group_source` INT(11) NOT NULL,
        `team_group_status` INT(11) NOT NULL,
        `notify_team_group_imported` INT(11) NOT NULL DEFAULT 1,
        `notify_type` VARCHAR(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
        `notify_ids` LONGTEXT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
        `responsible` INT(11) NOT NULL DEFAULT 0,
        `name` VARCHAR(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
        `form_data` LONGTEXT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
        `submitted_data` LONGTEXT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
        `recaptcha` INT(11) NOT NULL DEFAULT 0,
        `submit_btn_name` VARCHAR(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
        `submit_btn_text_color` VARCHAR(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT "#ffffff",
        `submit_btn_bg_color` VARCHAR(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT "#84c529",
        `success_submit_msg` MEDIUMTEXT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
        `submit_action` INT(11) NULL DEFAULT 0,
        `team_group_name_prefix` VARCHAR(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
        `submit_redirect_url` LONGTEXT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
        `language` VARCHAR(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
        `allow_duplicate` INT(11) NOT NULL DEFAULT 1,
        `mark_public` INT(11) NOT NULL DEFAULT 0,
        `track_duplicate_field` VARCHAR(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
        `track_duplicate_field_and` VARCHAR(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
        `create_task_on_duplicate` INT(11) NOT NULL DEFAULT 0,
        `dateadded` DATETIME NOT NULL,
        PRIMARY KEY (`id`)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;');
}
