<?php

defined('BASEPATH') or exit('No direct script access allowed');
hooks()->add_action('app_init', function () {
    if (file_exists(module_dir_path('team_group', 'views/tables/team_groups.php'))) {
        include_once(module_dir_path('team_group', 'views/tables/team_groups.php'));
    }
});
/**
 * Return group status label.
 * 
 * @param  string $status
 * @return string
 */
function format_group_status($status)
{
    if ($status == 'active') {
        return '<span class="label label-success">' . _l('active') . '</span>';
    } elseif ($status == 'inactive') {
        return '<span class="label label-danger">' . _l('inactive') . '</span>';
    }

    return '';
}

/**
 * Returns staff names by their IDs (comma separated).
 * 
 * @param  array $staff_ids
 * @return string
 */
function get_staff_names_by_ids($staff_ids)
{
    $CI = &get_instance();
    $CI->load->model('staff_model');

    if (!is_array($staff_ids)) {
        $staff_ids = explode(',', $staff_ids);
    }

    $names = [];
    foreach ($staff_ids as $id) {
        $staff = $CI->staff_model->get($id);
        if ($staff) {
            $names[] = get_staff_full_name($staff->staffid); // ✅ FIXED this line
        }
    }

    return implode(', ', $names);
}

/**
 * Safely JSON encode/decode checkbox staff fields.
 * 
 * @param  mixed $value
 * @param  bool  $decode
 * @return mixed
 */
function handle_multi_staff_field($staff_ids)
{
    // If $staff_ids is null or not an array, return empty JSON array
    if (!is_array($staff_ids)) {
        return json_encode([]);
    }

    // Filter out empty or invalid values and ensure unique IDs
    $staff_ids = array_filter($staff_ids, function ($id) {
        return !empty($id) && is_numeric($id);
    });

    // Remove duplicates and reindex array
    $staff_ids = array_unique($staff_ids);

    // Return JSON-encoded array
    return json_encode($staff_ids);
}
// function handle_multi_staff_field($value, $decode = false)
// {
//     return $decode ? json_decode($value, true) : json_encode(array_filter($value));
// }

function handle_team_group_attachments($team_groupid, $index_name = 'attachments', $form_activity = false)
{
    $CI = &get_instance();
    $CI->load->model('team_group_model');

    // ✅ Check if $_FILES[$index_name] exists
    if (!isset($_FILES[$index_name]) || !is_array($_FILES[$index_name]['name'])) {
        return []; // Return empty array to avoid errors
    }

    $files = $_FILES[$index_name];
    $uploaded_files = [];

    for ($i = 0; $i < count($files['name']); $i++) {
        if ($files['size'][$i] == 0) {
            continue;
        }

        _maybe_create_upload_path(TEAM_GROUP_ATTACHMENTS_FOLDER . $team_groupid);

        $path     = TEAM_GROUP_ATTACHMENTS_FOLDER . $team_groupid . '/';
        $tmpFilePath = $files['tmp_name'][$i];

        $filename = unique_filename($path, $files['name'][$i]);
        $newFilePath = $path . $filename;

        if (move_uploaded_file($tmpFilePath, $newFilePath)) {
            $CI->team_group_model->add_attachment_to_database($team_groupid, [[
                'file_name' => $filename,
                'filetype'  => $files['type'][$i],
            ]], false, $form_activity);

            $uploaded_files[] = $filename;
        }
    }

    return $uploaded_files;
}

function get_upload_team_group_path_by_type($type)
{
    $path = '';
    switch ($type) {
        case 'lead':
            $path = LEAD_ATTACHMENTS_FOLDER;

            break;
        case 'campaign':
            $path = CAMPAIGN_ATTACHMENTS_FOLDER;

            break;
        case 'expense':
            $path = EXPENSE_ATTACHMENTS_FOLDER;

            break;
        case 'project':
            $path = PROJECT_ATTACHMENTS_FOLDER;

            break;
        case 'proposal':
            $path = PROPOSAL_ATTACHMENTS_FOLDER;

            break;
        case 'estimate':
            $path = ESTIMATE_ATTACHMENTS_FOLDER;

            break;
        case 'invoice':
            $path = INVOICE_ATTACHMENTS_FOLDER;

            break;
        case 'credit_note':
            $path = CREDIT_NOTES_ATTACHMENTS_FOLDER;

            break;
        case 'task':
            $path = TASKS_ATTACHMENTS_FOLDER;

            break;
        case 'contract':
            $path = CONTRACTS_UPLOADS_FOLDER;

            break;
        case 'customer':
            $path = CLIENT_ATTACHMENTS_FOLDER;

            break;
        case 'staff':
            $path = STAFF_PROFILE_IMAGES_FOLDER;

            break;
        case 'company':
            $path = COMPANY_FILES_FOLDER;

            break;
        case 'ticket':
            $path = TICKET_ATTACHMENTS_FOLDER;

            break;
        case 'contact_profile_images':
            $path = CONTACT_PROFILE_IMAGES_FOLDER;

            break;
        case 'newsfeed':
            $path = NEWSFEED_FOLDER;

            break;
        case 'estimate_request':
            $path = NEWSFEED_FOLDER;

            break;
    }

    return hooks()->apply_filters('get_upload_path_by_type', $path, $type);
}

function team_group_consent_url($team_group_id)
{
    return admin_url('team_group/consent/' . $team_group_id);
}
