<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
defined('BASEPATH') or exit('No direct script access allowed');

class Team_group extends AdminController
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model('team_group_model');
        $this->load->helper('team_group');
    }

    public function index()
    {
        $data['title'] = _l('team_group_list');
        $data['groups'] = $this->team_group_model->get_all_groups();
        $this->load->view('index', $data);
    }

    public function report($id = '')
    {
       /* if (!is_admin()) {
            access_denied('Web To team_group Access');
        } */
        if ($this->input->is_ajax_request()) {
            $this->table_kpi_team_report();
            return;
        }
        $data['title'] = _l('team_group_report');
		$this->db->select('id, group_name');
		$this->db->where('status', 'active');
		$data['team_groups'] = $this->db->get(db_prefix() . 'team_groups')->result_array();
        $this->load->view('team_group/report', $data);
    }

    /*public function get_report_table_data()
    {
		
        $aColumns = ['id', 'name', 'dateadded'];
        $sIndexColumn = 'id';
        $sTable = db_prefix() . 'kpi_team_report';
        $result = data_tables_init($aColumns, $sIndexColumn, $sTable, [], [], ['form_key', 'id']);
        $output = $result['output'];
        $rResult = $result['rResult'];
        foreach ($rResult as $aRow) {
            $row = [];
            foreach ($aColumns as $column) {
                $_data = $aRow[$column];
                if ($column == 'name') {
                    $_data = '<span class="tw-font-medium">' . e($_data) . '</span>';
                } elseif ($column == 'dateadded') {
                    $_data = '<span class="text-has-action is-date" data-toggle="tooltip" data-title="' . e(_dt($_data)) . '">' . e(time_ago($_data)) . '</span>';
                }
                $row[] = $_data;
            }
            $actions = '<div class="row-options">';
            $actions = '<a href="' . admin_url('team_group/view_form_data/' . $aRow['id']) . '" class="btn btn-sm btn-default">' . _l('view_form_data') . '</a>';
            $actions .= '</div>';
            $row[] = $actions;
            $row['DT_RowClass'] = 'has-row-options';
            $output['aaData'][] = $row;
        }
        echo json_encode($output);
    }*/

public function get_report_table_data()
{
    // Use table alias to avoid ambiguous column error
    $aColumns = [
        'ktr.id as id',
        'ktr.name as name',
        '(SELECT COUNT(id) FROM ' . db_prefix() . 'kpi_form_list WHERE ' . db_prefix() . 'kpi_form_list.form_id = ktr.id) as total_submissions',
        '(SELECT MAX(dateadded) FROM ' . db_prefix() . 'kpi_form_list WHERE ' . db_prefix() . 'kpi_form_list.form_id = ktr.id) as last_submission_time',
        'ktr.dateadded as dateadded',
    ];
    $sIndexColumn = 'ktr.id'; // Fully qualified index column
    $sTable = db_prefix() . 'kpi_team_report ktr'; // Table with alias

    // Join with team_groups for non-admin filtering
    $join = [
        'LEFT JOIN ' . db_prefix() . 'team_groups tg
            ON JSON_CONTAINS(ktr.team_group_id, CONCAT(\'"\', tg.id, \'"\'))'
    ];

    // Where conditions
    $where = [];
    $logged_in_user_id = get_staff_user_id();

    // Apply filtering for non-admin users
    if (!is_admin()) {
        $where[] = '(JSON_CONTAINS(tg.manager_ids, \'"' . $logged_in_user_id . '"\')
            OR JSON_CONTAINS(tg.tl_ids, \'"' . $logged_in_user_id . '"\'))';
    }

    // Handle team_group_id filter from DataTable or select input
    $team_group_id = $this->input->post('team_group_id') ?: $this->input->get('team_group_id');
    if (!empty($team_group_id)) {
        $team_group_id = $this->db->escape_str($team_group_id); // Sanitize input
        $where[] = "JSON_CONTAINS(ktr.team_group_id, '\"$team_group_id\"')";
    }

    // Get results, include form_key for action links
    $result = data_tables_init($aColumns, $sIndexColumn, $sTable, $join, $where, ['ktr.form_key']);

    // Debug: Log the compiled query
    $query = $this->db->get_compiled_select();
    log_message('debug', 'SQL Query: ' . $query);
    log_message('debug', 'data_tables_init result: ' . print_r($result, true));

    $output = $result['output'];
    $rResult = $result['rResult'];

    // Initialize aaData
    $output['aaData'] = [];

    // Map aliased columns to their expected keys
    $columnKeys = [
        'ktr.id as id' => 'id',
        'ktr.name as name' => 'name',
        '(SELECT COUNT(id) FROM ' . db_prefix() . 'kpi_form_list WHERE ' . db_prefix() . 'kpi_form_list.form_id = ktr.id) as total_submissions' => 'total_submissions',
        '(SELECT MAX(dateadded) FROM ' . db_prefix() . 'kpi_form_list WHERE ' . db_prefix() . 'kpi_form_list.form_id = ktr.id) as last_submission_time' => 'last_submission_time',
        'ktr.dateadded as dateadded' => 'dateadded',
    ];

    foreach ($rResult as $aRow) {
        $row = [];
        foreach ($aColumns as $column) {
            // Use the aliased column key
            $key = $columnKeys[$column] ?? $column;

            // Safely access the column, default to empty string if missing
            $_data = isset($aRow[$key]) ? $aRow[$key] : '';

            if ($key == 'name') {
                $_data = '<span class="tw-font-medium">' . e($_data) . '</span>';
            } elseif ($key == 'dateadded') {
                $_data = $_data ? '<span class="text-has-action is-date" data-toggle="tooltip" data-title="' . e(_dt($_data)) . '">' . e(time_ago($_data)) . '</span>' : '';
            } elseif ($key == 'total_submissions') {
                $_data = e($_data);
            } elseif ($key == 'last_submission_time') {
                $_data = $_data ? date('Y-m-d H:i:s', strtotime($_data)) : '-';
            }

            $row[] = $_data;
        }

        // Action column
        $actions = '<a href="' . admin_url('team_group/view_form_data/' . (isset($aRow['id']) ? $aRow['id'] : 0)) . '" class="btn btn-sm btn-default">' . _l('view_form_data') . '</a>';
        $row[] = $actions;

        $row['DT_RowClass'] = 'has-row-options'; // Keep for consistency
        $output['aaData'][] = $row;
    }

    // Debug: Log the final output
    log_message('debug', 'Final output: ' . print_r($output, true));
    echo json_encode($output);
}


    public function create($id = null)
    {
        $data['title'] = $id ? _l('edit_team_group') : _l('create_team_group');
        $data['staff_members'] = $this->staff_model->get('', ['active' => 1]);
        if ($this->input->post()) {
            $result = $this->team_group_model->add_group($this->input->post(), $id);
            if ($result) {
                $msg = $id ? _l('updated_successfully', _l('team_group')) : _l('added_successfully', _l('team_group'));
                set_alert('success', $msg);
                redirect(admin_url('team_group'));
            }
        }
        if ($id) {
            $data['group'] = $this->team_group_model->get_groups($id);
        }
        $this->load->view('create', $data);
    }

    public function edit($id)
    {
        $this->load->model('team_group_model');
        $group = $this->team_group_model->get_group_by_id($id);
        if (!$group) {
            set_alert('warning', 'Group not found');
            redirect(admin_url('team_group'));
        }
        $data['group'] = $group;
        $data['staff_members'] = $this->team_group_model->get_all_staff();
        $data['title'] = _l('edit_team_group');
        $this->load->view('edit_team_group', $data);
    }

    public function delete($id)
    {
        if (!$id) {
            redirect(admin_url('team_group'));
        }
        $response = $this->team_group_model->delete_group($id);
        if ($response) {
            set_alert('success', _l('deleted', _l('team_group')));
        } else {
            set_alert('warning', _l('problem_deleting', _l('team_group')));
        }
        redirect(admin_url('team_group'));
    }

    public function save_group()
    {
        $id = $this->input->post('id');
        $data = $this->input->post();
        $success = $this->team_group_model->add_group($data, $id);
        if ($success) {
            if ($id) {
                set_alert('success', _l('updated_successfully', _l('team_group')));
            } else {
                set_alert('success', _l('added_successfully', _l('team_group')));
            }
        } else {
            set_alert('warning', _l('no_changes_made'));
        }
        redirect(admin_url('team_group'));
    }

    public function table()
    {
        $type = strtolower($this->input->get('type'));
        if ($type === 'sub_groups') {
            $output = $this->get_table_data('team_sub_groups');
        } else {
            $output = $this->get_table_data('team_groups');
        }
        $this->output
            ->set_content_type('application/json')
            ->set_output(json_encode($output));
    }

    public function get_table_data($table)
    {
        $table_path = FCPATH . 'modules/team_group/views/tables/' . $table . '.php';
        if (!file_exists($table_path)) {
            show_error('Table file not found: ' . $table_path);
        }
        ob_start();
        $output = include($table_path);
        ob_end_clean();
        file_put_contents(FCPATH . 'modules/team_group/views/tables/test_log.txt', "Output from team_groups.php: " . print_r($output, true) . "\n", FILE_APPEND);
        if (!isset($output) || !is_array($output)) {
            show_error('Invalid or undefined output from table file: ' . $table);
        }
        return $output;
    }

    public function team_sub_group()
    {
        $data['title'] = _l('team_sub_group_list');
        $this->load->view('sub_group_list', $data);
    }

    public function create_sub_group($id = null)
    {
        $data['title'] = $id ? _l('edit_sub_group') : _l('add_sub_group');
        $data['team_groups'] = $this->team_group_model->get_groups();
        $data['staff_members'] = $this->staff_model->get('', ['active' => 1]);
        if ($id) {
            $sub_group = $this->team_group_model->get_subgroups($id);
            if (!$sub_group) {
                set_alert('warning', _l('sub_group_not_found'));
                redirect(admin_url('team_group/team_sub_group'));
            }
            $manager_ids = !empty($sub_group['managers']) ? json_decode($sub_group['managers'], true) : [];
            $sub_group['manager_names'] = [];
            if (!empty($manager_ids)) {
                $managers = $this->staff_model->get('', ['staffid' => $manager_ids]);
                $sub_group['manager_names'] = array_map(function($manager) {
                    return $manager['firstname'] . ' ' . $manager['lastname'];
                }, $managers);
            }
            $data['sub_group'] = $sub_group;
        } else {
            $data['sub_group'] = null;
        }
        if ($this->input->post()) {
            $postData = $this->input->post();
            //$required_fields = ['sub_group_name', 'group_id', 'employees', 'clients', 'consultant', 'status'];
			$required_fields = ['sub_group_name', 'group_id', 'employees'];
            $missing_fields = [];
            foreach ($required_fields as $field) {
                if (empty($postData[$field])) {
                    $missing_fields[] = $field;
                }
            }
            if (!empty($missing_fields)) {
                set_alert('danger', 'Missing required fields: ' . implode(', ', $missing_fields));
                redirect(admin_url('team_group/team_sub_group'));
            }
            $postData['tl_ids'] = isset($postData['team_leaders']) ? $postData['team_leaders'] : [];
            $postData['managers'] = isset($postData['sub_group_manager_ids']) ? json_decode($postData['sub_group_manager_ids'], true) : [];
            $postData['consultants'] = isset($postData['consultant']) ? $postData['consultant'] : [];
            if ($id) {
                $success = $this->team_group_model->update_subgroup($postData, $id);
                if ($success) {
                    set_alert('success', _l('updated_successfully', _l('sub_group')));
                } else {
                    set_alert('danger', _l('failed_to_update_sub_group'));
                }
            } else {
                $newId = $this->team_group_model->add_subgroup($postData);
                if ($newId) {
                    set_alert('success', _l('added_successfully', _l('sub_group')));
                } else {
                    set_alert('danger', _l('failed_to_add_sub_group') . ': Check database logs for details.');
                }
            }
            redirect(admin_url('team_group/team_sub_group'));
        }
        $this->load->view('create_sub_group', $data);
    }

    public function get_group_managers()
    {
        if ($this->input->is_ajax_request()) {
            $group_id = $this->input->post('group_id');
            $this->db->select('manager_ids');
            $this->db->where('id', $group_id);
            $group = $this->db->get(db_prefix() . 'team_groups')->row();
            $response = ['success' => false, 'manager_names' => '', 'manager_ids' => '[]'];
            if ($group && !empty($group->manager_ids)) {
                $manager_ids = json_decode($group->manager_ids, true);
                if (!empty($manager_ids)) {
                    $this->db->select('CONCAT(firstname, " ", lastname) as full_name');
                    $this->db->where_in('staffid', $manager_ids);
                    $managers = $this->db->get(db_prefix() . 'staff')->result_array();
                    $manager_names = array_column($managers, 'full_name');
                    $response = [
                        'success' => true,
                        'manager_names' => implode(', ', $manager_names),
                        'manager_ids' => json_encode($manager_ids)
                    ];
                }
            }
            $this->output
                ->set_content_type('application/json')
                ->set_output(json_encode($response));
        }
    }

    public function edit_sub_group($id)
    {
        $this->load->model('team_group_model');
        $this->load->model('staff_model');
        $sub_group = $this->team_group_model->get_sub_group_by_id($id);
        if (!$sub_group) {
            set_alert('warning', _l('sub_group_not_found'));
            redirect(admin_url('team_group/team_sub_group'));
        }
        $sub_group = (array) $sub_group;
        $manager_ids = !empty($sub_group['sub_group_manager']) ? json_decode($sub_group['sub_group_manager'], true) : [];
        $sub_group['manager_names'] = [];
        if (!empty($manager_ids)) {
            $this->db->where_in('staffid', $manager_ids);
            $managers = $this->staff_model->get();
            if ($managers) {
                $sub_group['manager_names'] = array_map(function($manager) {
                    return $manager['firstname'] . ' ' . $manager['lastname'];
                }, $managers);
            }
        }
        $sub_group = array_merge([
            'id' => $id,
            'sub_group_name' => '',
            'team_group_id' => '',
            'sub_group_manager' => '[]',
            'tl_ids' => '[]',
            'employee_ids' => '[]',
            'client' => '[]',
            'consultant' => '[]',
            'status' => ''
        ], $sub_group);
        $data['sub_group'] = $sub_group;
        $data['team_groups'] = $this->team_group_model->get_groups();
        $data['staff_members'] = $this->staff_model->get('', ['active' => 1]);
        $data['title'] = _l('edit_team_sub_group');
        $this->load->view('create_sub_group', $data);
    }

    public function delete_sub_group($id)
    {
        if (!$id) {
            show_404();
        }
        $response = $this->team_group_model->delete_subgroup($id);
        if ($response) {
            set_alert('success', _l('deleted', _l('team_group')));
        } else {
            set_alert('warning', _l('problem_deleting', _l('team_group')));
        }
        redirect(admin_url('team_group/team_sub_group'));
    }

    public function save_form_data()
    {
        $data = $this->input->post();
        if (!isset($data['formData']) || isset($data['formData']) && !$data['formData']) {
            echo json_encode([
                'success' => false,
            ]);
            die;
        }
        $data['formData'] = preg_replace('/=\\\\/m', "=''", $data['formData']);
        $this->db->where('id', $data['id']);
        $this->db->update(db_prefix() . 'kpi_team_report', [
            'form_data' => $data['formData'],
        ]);
        if ($this->db->affected_rows() > 0) {
            $this->team_group_model->log_kpi_activity($data['id'], 'not_kpi_activity_form_data_updated');
            echo json_encode([
                'success' => true,
                'message' => _l('updated_successfully', _l('kpi_team_report_form')),
            ]);
        } else {
            echo json_encode([
                'success' => false,
            ]);
        }
    }

    public function form($id = '')
    {
        if (!is_admin()) {
            access_denied('Web To team_group Access');
        }
        if ($this->input->post()) {
            if ($id == '') {
                $data = $this->input->post();
                $id = $this->team_group_model->add_form($data);
                if ($id) {
                    set_alert('success', _l('added_successfully', _l('kpi_team_report_form')));
                    redirect(admin_url('team_group/form/' . $id));
                }
            } else {
                $success = $this->team_group_model->update_form($id, $this->input->post());
                if ($success) {
                    set_alert('success', _l('updated_successfully', _l('kpi_team_report_form')));
                }
                redirect(admin_url('team_group/form/' . $id));
            }
        }
        $data['formData'] = [];
        $custom_fields = get_custom_fields('team_groups', 'type != "link"');
        $cfields = format_external_form_custom_fields($custom_fields);
        $data['title'] = _l('kpi_team_report');
        if ($id != '') {
            $data['form'] = $this->team_group_model->get_form([
                'id' => $id,
            ]);
            $data['title'] = $data['form']->name . ' - ' . _l('kpi_team_report_form');
            $data['formData'] = $data['form']->form_data;
        }
        $this->load->model('roles_model');
        $data['roles'] = $this->roles_model->get();
        $data['members'] = $this->staff_model->get('', [
            'active' => 1,
            'is_not_staff' => 0,
        ]);
        $this->db->select('id, group_name');
        $this->db->where('status', 'active');
        $data['team_groups'] = $this->db->get(db_prefix() . 'team_groups')->result_array();
        $this->db->select('id, team_group_id, sub_group_name');
        $this->db->where('status', 'active');
        $data['team_sub_groups'] = $this->db->get(db_prefix() . 'team_sub_groups')->result_array();
        $data['languages'] = $this->app->get_available_languages();
        $data['cfields'] = $cfields;
        $db_fields = [];
        $fields = [
            'name'
        ];
        $fields = hooks()->apply_filters('team_group_form_available_database_fields', $fields);
        $className = 'form-control';
        foreach ($fields as $f) {
            $_field_object = new stdClass();
            $type = 'text';
            $subtype = '';
            if ($f == 'email') {
                $subtype = 'email';
            } elseif ($f == 'description' || $f == 'address') {
                $type = 'textarea';
            } elseif ($f == 'country') {
                $type = 'select';
            }
            if ($f == 'name') {
                $label = _l('team_group_add_edit_name');
            } elseif ($f == 'email') {
                $label = _l('team_group_add_edit_email');
            } elseif ($f == 'phonenumber') {
                $label = _l('team_group_add_edit_phonenumber');
            } elseif ($f == 'team_group_value') {
                $label = _l('team_group_add_edit_team_group_value');
                $type = 'number';
            } else {
                $label = _l('team_group_' . $f);
            }
            $field_array = [
                'subtype' => $subtype,
                'type' => $type,
                'label' => $label,
                'className' => $className,
                'name' => $f,
            ];
            if ($f == 'country') {
                $field_array['values'] = [];
                $field_array['values'][] = [
                    'label' => '',
                    'value' => '',
                    'selected' => false,
                ];
                $countries = get_all_countries();
                foreach ($countries as $country) {
                    $selected = false;
                    if (get_option('customer_default_country') == $country['country_id']) {
                        $selected = true;
                    }
                    array_push($field_array['values'], [
                        'label' => $country['short_name'],
                        'value' => (int) $country['country_id'],
                        'selected' => $selected,
                    ]);
                }
            }
            if ($f == 'name') {
                $field_array['required'] = true;
            }
            $_field_object->label = $label;
            $_field_object->name = $f;
            $_field_object->fields = [];
            $_field_object->fields[] = $field_array;
            $db_fields[] = $_field_object;
        }
        $data['bodyclass'] = 'web-to-team_group-form';
        $data['db_fields'] = $db_fields;
        $this->load->view('team_group/formbuilder', $data);
    }

    public function get_sub_groups_by_team_group($team_group_id)
    {
        if ($this->input->is_ajax_request()) {
            $this->db->select('id, sub_group_name');
            $this->db->where('team_group_id', $team_group_id);
            $this->db->where('status', 'active');
            $sub_groups = $this->db->get(db_prefix() . 'team_sub_groups')->result_array();
            if (!empty($sub_groups)) {
                echo json_encode([
                    'success' => true,
                    'sub_groups' => $sub_groups
                ]);
            } else {
                echo json_encode([
                    'success' => false
                ]);
            }
        } else {
            show_404();
        }
    }

    public function table_kpi_team_report()
	{
		if (!$this->input->is_ajax_request()) {
			ajax_access_denied();
		}

		// Get the team_group_id from the query parameter
		$team_group_id = $this->input->get('team_group_id');

		// Pass team_group_id to the table view
		$this->load->view('team_group/tables/web_to_team_group', ['team_group_id' => $team_group_id]);
	}

    public function forms($id = '')
    {
        if ($this->input->is_ajax_request()) {
            $this->table_kpi_team_report();
            return;
        }
		 $this->db->select('id, group_name');
        $this->db->where('status', 'active');
        $data['team_groups'] = $this->db->get(db_prefix() . 'team_groups')->result_array();
        $data['title'] = _l('kpi_team_report');
        $this->load->view('team_group/forms', $data);
    }

    public function wtl($key = '')
    {
        if (!$key) {
            show_404();
        }
        $this->load->model('team_group_model');
        $form = $this->team_group_model->get_form(['form_key' => $key]);
        if (!$form) {
            show_404();
        }
        $GLOBALS['locale'] = get_locale_key($form->language);
        $data['form_fields'] = $form->form_data ? json_decode($form->form_data) : [];
        if ($this->input->post('key') && $this->input->post('key') == $key) {
            $post_data = $this->input->post();
            $required = [];
            foreach ($data['form_fields'] as $field) {
                if (isset($field->required)) {
                    $required[] = $field->name;
                }
            }
            if (is_gdpr() && get_option('gdpr_enable_terms_and_conditions_team_group_form') == 1) {
                $required[] = 'accept_terms_and_conditions';
            }
            foreach ($required as $field) {
                if ($field == 'file-input') {
                    continue;
                }
                if (!isset($post_data[$field]) || empty($post_data[$field])) {
                    $this->output->set_status_header(422);
                    exit;
                }
            }
            if (show_recaptcha() && $form->recaptcha == 1) {
                if (!do_recaptcha_validation($post_data['g-recaptcha-response'])) {
                    echo json_encode([
                        'success' => false,
                        'message' => _l('recaptcha_error'),
                    ]);
                    exit;
                }
            }
            if (isset($post_data['g-recaptcha-response'])) {
                unset($post_data['g-recaptcha-response']);
            }
            unset($post_data['key']);
            $regular_fields = [];
            $custom_fields = [];
            foreach ($post_data as $name => $val) {
                if (strpos($name, 'form-cf-') !== false) {
                    $custom_fields[] = ['name' => $name, 'value' => $val];
                } else {
                    if ($this->db->field_exists($name, db_prefix() . 'kpi_form_list')) {
                        if ($name == 'country') {
                            if (!is_numeric($val)) {
                                if ($val == '') {
                                    $val = 0;
                                } else {
                                    $this->db->where('iso2', $val);
                                    $this->db->or_where('short_name', $val);
                                    $this->db->or_where('long_name', $val);
                                    $country = $this->db->get(db_prefix() . 'countries')->row();
                                    $val = $country ? $country->country_id : 0;
                                }
                            }
                        } elseif ($name == 'address') {
                            $val = nl2br(trim($val));
                        }
                        $regular_fields[$name] = $val;
                    }
                }
            }
            $success = false;
            $insert_to_db = true;
            if ($form->allow_duplicate == 0) {
                $where = [];
                if (!empty($form->track_duplicate_field) && isset($regular_fields[$form->track_duplicate_field])) {
                    $where[$form->track_duplicate_field] = $regular_fields[$form->track_duplicate_field];
                }
                if (!empty($form->track_duplicate_field_and) && isset($regular_fields[$form->track_duplicate_field_and])) {
                    $where[$form->track_duplicate_field_and] = $regular_fields[$form->track_duplicate_field_and];
                }
                if (count($where) > 0) {
                    $total = total_rows(db_prefix() . 'kpi_form_list', $where);
                    $duplicateLead = false;
                    if ($total == 1) {
                        $this->db->where($where);
                        $duplicateLead = $this->db->get(db_prefix() . 'kpi_form_list')->row();
                    }
                    if ($total > 0) {
                        $success = true;
                        $insert_to_db = false;
                        if ($form->create_task_on_duplicate == 1) {
                            $task_name = $regular_fields['name'] ?? $regular_fields['email'] ?? $regular_fields['company'] ?? $form->name;
                            if (!isset($regular_fields['name']) && !isset($regular_fields['email']) && !isset($regular_fields['company'])) {
                                $task_name .= ' - ' . $form->name;
                            }
                            $description = $form->name . '<br /><br />';
                            $fields_labels = [];
                            foreach ($data['form_fields'] as $f) {
                                if (!in_array($f->type, ['header', 'paragraph', 'file'])) {
                                    $fields_labels[$f->name] = $f->label;
                                }
                            }
                            $all_fields = array_merge($regular_fields, array_column($custom_fields, 'value', 'name'));
                            foreach ($all_fields as $name => $val) {
                                if (isset($fields_labels[$name])) {
                                    if ($name == 'country' && is_numeric($val)) {
                                        $c = get_country($val);
                                        $val = $c ? $c->short_name : 'Unknown';
                                    }
                                    $description .= $fields_labels[$name] . ': ' . $val . '<br />';
                                }
                            }
                            $task_data = [
                                'name' => $task_name,
                                'priority' => get_option('default_task_priority'),
                                'dateadded' => date('Y-m-d H:i:s'),
                                'startdate' => date('Y-m-d'),
                                'description' => $description,
                            ];
                            $task_data = hooks()->apply_filters('before_add_task', $task_data);
                            $this->db->insert(db_prefix() . 'tasks', $task_data);
                            $task_id = $this->db->insert_id();
                            if ($task_id) {
                                $attachment = handle_task_attachments_array($task_id, 'file-input');
                                if (!empty($attachment)) {
                                    $this->tasks_model->add_attachment_to_database($task_id, $attachment, false, false);
                                }
                                $this->tasks_model->add_task_assignees([
                                    'taskid' => $task_id,
                                    'assignee' => $form->responsible,
                                ], true);
                                hooks()->do_action('after_add_task', $task_id);
                                if ($duplicateLead && $duplicateLead->email != '') {
                                    send_mail_template('team_group_web_form_submitted', $duplicateLead);
                                }
                            }
                        }
                    }
                }
            }
            if ($insert_to_db) {
                if (empty($regular_fields['name'])) {
                    $regular_fields['name'] = 'Unknown';
                }
                $regular_fields['name'] = $form->team_group_name_prefix . $regular_fields['name'];
                $regular_fields['dateadded'] = date('Y-m-d H:i:s');
                $regular_fields['form_id'] = $form->id;
                $submitted_data = [];
                foreach ($data['form_fields'] as $field) {
                    if (in_array($field->type, ['header', 'paragraph', 'file'])) {
                        continue;
                    }
                    $field_name = $field->name;
                    $field_label = $field->label;
                    if (isset($post_data[$field_name])) {
                        $value = $post_data[$field_name];
                        $value = is_array($value) ? implode(',', $value) : $value;
                        $unique_label = $field_label;
                        if (isset($submitted_data[$unique_label])) {
                            $i = 2;
                            while (isset($submitted_data[$unique_label . ' #' . $i])) {
                                $i++;
                            }
                            $unique_label = $unique_label . ' #' . $i;
                        }
                        $submitted_data[$unique_label] = $value;
                    } else {
                        $submitted_data[$field_label] = '';
                    }
                }
                $this->db->insert(db_prefix() . 'kpi_form_list', [
                    'form_id' => $form->id,
                    'submitted_data' => json_encode($submitted_data),
                    'dateadded' => $regular_fields['dateadded'],
                ]);
                $team_group_id = $this->db->insert_id();
                if ($team_group_id) {
                    $this->team_group_model->log_kpi_activity($form->id, 'not_kpi_activity_form_submitted', false, json_encode($submitted_data));
                    hooks()->do_action('team_group_created', [
                        'team_group_id' => $team_group_id,
                        'web_to_team_group_form' => true,
                    ]);
                    $success = true;
                }
            }
            if ($success) {
                hooks()->do_action('web_to_team_group_form_submitted', [
                    'team_group_id' => $team_group_id ?? 0,
                    'form_id' => $form->id,
                    'task_id' => $task_id ?? 0,
                ]);
            }
            $response = ['success' => $success];
            if ($form->submit_action === '0') {
                $response['message'] = $form->success_submit_msg;
            }
            echo json_encode($response);
            exit;
        }
        $data['form'] = $form;
        $this->load->view('forms/web_to_team_group', $data);
    }

    public function view_form_data($form_id = '')
    {
        if (!$form_id) {
            show_404();
        }
        $this->load->model('team_group_model');
        $form = $this->team_group_model->get_form(['id' => $form_id]);
        if (!$form) {
            show_404();
        }
        log_message('debug', 'Form ID: ' . $form_id);
        $data['form'] = $form;
        $data['title'] = _l('view_form_data') . ' - ' . $form->name;
        $this->load->view('team_group/view_form_data', $data);
    }
	public function view_form_data_table($form_id)
	{
		$this->load->model('team_group_model');

		$pivot = $this->team_group_model->get_pivoted_form_submissions($form_id);
		$columns = $pivot['columns'];
		$rows = $pivot['rows'];

		// Columns for sorting: form_id + dynamic columns + dateadded
		$columns_for_sort = array_merge(['form_id'], $columns, ['dateadded']);

		// Get DataTables params
		$draw = (int) $this->input->post('draw');
		$start = (int) $this->input->post('start');
		$length = (int) $this->input->post('length');
		$search_value = $this->input->post('search')['value'] ?? '';
		$order = $this->input->post('order')[0] ?? null;

		// 1. Sorting
		if ($order) {
			$column_index = (int) $order['column'];
			$dir = $order['dir'];
			$sort_column = $columns_for_sort[$column_index] ?? null;

			if ($sort_column) {
				usort($rows, function ($a, $b) use ($sort_column, $dir) {
					$valA = null;
					$valB = null;

					if ($sort_column === 'form_id') {
						$valA = $a['form_id'];
						$valB = $b['form_id'];
					} elseif ($sort_column === 'dateadded') {
						$valA = strtotime($a['dateadded']);
						$valB = strtotime($b['dateadded']);
					} else {
						$valA = $a['submitted_data'][$sort_column] ?? '';
						$valB = $b['submitted_data'][$sort_column] ?? '';
					}

					// Normalize values for comparison
					if (is_string($valA)) $valA = strtolower($valA);
					if (is_string($valB)) $valB = strtolower($valB);

					if ($valA == $valB) return 0;

					if ($dir === 'asc') {
						return ($valA < $valB) ? -1 : 1;
					} else {
						return ($valA > $valB) ? -1 : 1;
					}
				});
			}
		}

		// 2. Search Filtering
		$filtered_rows = [];

		if ($search_value === '') {
			$filtered_rows = $rows;
		} else {
			$search_value_lower = strtolower($search_value);

			foreach ($rows as $row) {
				$found = false;

				// Check form_id
				if (stripos($row['form_id'], $search_value) !== false) {
					$found = true;
				} else {
					// Check all submitted_data values
					foreach ($row['submitted_data'] as $val) {
						if (stripos($val, $search_value) !== false) {
							$found = true;
							break;
						}
					}
				}

				if ($found) {
					$filtered_rows[] = $row;
				}
			}
		}

		$records_total = count($rows);
		$records_filtered = count($filtered_rows);

		// 3. Pagination (slice the filtered rows)
		$paged_rows = array_slice($filtered_rows, $start, $length);

		// 4. Prepare output data array
		$data = [];

		foreach ($paged_rows as $row) {
			$r = [];
			
            $r[] = '<a href="javascript:void(0)" class="view-submission" data-id="' . $row['id'] . '">' . $row['id'] . '</a>';
            $r[] = $row['form_id'];
			foreach ($columns as $col) {
				$r[] = e($row['submitted_data'][$col] ?? '-');
			}

			$r[] = '<span class="text-has-action is-date" data-toggle="tooltip" data-title="' . e(_dt($row['dateadded'])) . '">' . e(time_ago($row['dateadded'])) . '</span>';

			$data[] = $r;
		}

		// 5. Send JSON response for DataTables
		$output = [
			'draw' => $draw,
			'recordsTotal' => $records_total,
			'recordsFiltered' => $records_filtered,
			'data' => $data,
		];

		echo json_encode($output);
	}
public function get_submission_details($id)
{
    $this->db->where('id', $id);
    $result = $this->db->get(db_prefix() . 'kpi_form_list')->row();
 
    if ($result) {
        $data = json_decode($result->submitted_data, true) ?? [];
        echo json_encode([
            'id' => $result->id,
            'form_id' => $result->form_id,
            'submitted_data' => $data,
            'dateadded' => _dt($result->dateadded)
        ]);
    } else {
        echo json_encode(['error' => 'Not found']);
    }
}
 

  /*  public function view_form_data_table($form_id)
    {
        $this->load->model('team_group_model');
        $pivot = $this->team_group_model->get_pivoted_form_submissions($form_id);
        $columns = $pivot['columns'];
        $rows = $pivot['rows'];
        $output = [
            'draw' => (int) $this->input->post('draw'),
            'recordsTotal' => count($rows),
            'recordsFiltered' => count($rows),
            'data' => []
        ];
        foreach ($rows as $row) {
            $r = [];
            $r[] = $row['form_id'];
            foreach ($columns as $col) {
                $r[] = e($row['submitted_data'][$col] ?? '-');
            }
            $r[] = '<span class="text-has-action is-date" data-toggle="tooltip" data-title="' . e(_dt($row['dateadded'])) . '">' . e(time_ago($row['dateadded'])) . '</span>';
            $output['data'][] = $r;
        }
        echo json_encode($output);
    } */

    public function insert_form_submission($form_id, $form_data_array)
    {
        $json_data = json_encode($form_data_array);
        $this->db->insert(db_prefix() . 'kpi_form_list', [
            'form_id' => $form_id,
            'submitted_data' => $json_data,
            'dateadded' => date('Y-m-d H:i:s')
        ]);
        $insert_id = $this->db->insert_id();
        if ($insert_id) {
            $this->team_group_model->log_kpi_activity($form_id, 'not_kpi_activity_form_submitted', false, $json_data);
        }
        return $insert_id;
    }

    public function delete_form($id)
    {
        $success = $this->team_group_model->delete_form($id);
        if ($success) {
            set_alert('success', _l('deleted', _l('kpi_team_report_form')));
        }
        redirect(admin_url('team_group/forms'));
    }
	
	private function get_pivoted_data($form_id)
	{
		$this->load->model('team_group_model');
		$pivot = $this->team_group_model->get_pivoted_form_submissions($form_id);
		$columns = $pivot['columns'];
		$rows = $pivot['rows'];

		if (empty($rows)) {
			return ['columns' => [], 'raw_data' => []];
		}

		// Build pivoted rows: [id, field1_val, field2_val, ..., dateadded_raw]
		$pivoted_data = [];
		foreach ($rows as $row) {
			$row_data = [$row['id']]; // ID
			foreach ($columns as $field) {
				$row_data[] = $row['submitted_data'][$field] ?? '-';
			}
			$row_data[] = $row['dateadded']; // Date raw
			$pivoted_data[] = $row_data;
		}

		return ['columns' => $columns, 'raw_data' => $pivoted_data];
	}

	public function kpi_report_individual($form_id = null)
	{
		$data['title'] = _l('kpi_report_of_individual');
		$logged_in_user_id = get_staff_user_id();

		// Get accessible forms (include sub-groups for members)
		$this->db->select('ktr.id, ktr.name, ktr.dateadded, ktr.form_key');
		$this->db->from(db_prefix() . 'kpi_team_report ktr');
		$this->db->join(db_prefix() . 'team_groups tg', 'JSON_CONTAINS(ktr.team_group_id, CONCAT(\'"\', tg.id, \'"\'))', 'left');
		$this->db->join(db_prefix() . 'team_sub_groups tsg', 'tsg.team_group_id = tg.id', 'left');
		if (!is_admin()) {
			$user = $this->db->escape_str($logged_in_user_id);
			//$this->db->where('(JSON_CONTAINS(tg.member_ids, \'"' . $user . '"\') OR JSON_CONTAINS(tsg.member_ids, \'"' . $user . '"\'))', NULL, FALSE);
			$this->db->where('(
				JSON_CONTAINS(tg.manager_ids, \'"' . $user . '"\')
				OR JSON_CONTAINS(tg.tl_ids, \'"' . $user . '"\')
				OR JSON_CONTAINS(tsg.employee_ids, \'"' . $user . '"\')
			)', NULL, FALSE);

		}
		$this->db->group_by('ktr.id');
		$this->db->order_by('ktr.dateadded', 'DESC');
		$data['forms'] = $this->db->get()->result_array();

		$selected_form_id = $form_id ?: (!empty($data['forms']) ? $data['forms'][0]['id'] : null);
		$data['current_form_id'] = $selected_form_id;

		$data['thead_columns'] = [];
		if ($selected_form_id) {
			$pivoted = $this->get_pivoted_data($selected_form_id);
			$data['thead_columns'] = array_merge(
				[_l('id')],
				$pivoted['columns'],
				[_l('team_group_dt_datecreated')],
				[_l('action')]
			);
		}

		$this->load->view('team_group/kpi_report_individual', $data);
	}

	public function individual_form_data_table($form_id)
	{
		if (!$form_id) {
			echo json_encode(['aaData' => []]);
			return;
		}

		$logged_in_user_id = get_staff_user_id();
		// Access check (include sub-groups for members)
		$this->db->select('1');
		$this->db->from(db_prefix() . 'kpi_team_report ktr');
		$this->db->join(db_prefix() . 'team_groups tg', 'JSON_CONTAINS(ktr.team_group_id, CONCAT(\'"\', tg.id, \'"\'))', 'left');
		$this->db->join(db_prefix() . 'team_sub_groups tsg', 'tsg.team_group_id = tg.id', 'left');
		$this->db->where('ktr.id', $form_id);
		if (!is_admin()) {
			$user = $this->db->escape_str($logged_in_user_id);
			//$this->db->where('(JSON_CONTAINS(tg.member_ids, \'"' . $user . '"\') OR JSON_CONTAINS(tsg.member_ids, \'"' . $user . '"\'))', NULL, FALSE);
			$this->db->where('(
				JSON_CONTAINS(tg.manager_ids, \'"' . $user . '"\')
				OR JSON_CONTAINS(tg.tl_ids, \'"' . $user . '"\')
				OR JSON_CONTAINS(tsg.employee_ids, \'"' . $user . '"\')
			)', NULL, FALSE);

		}
		if ($this->db->count_all_results() == 0) {
			echo json_encode(['aaData' => []]);
			return;
		}

		// Get pivoted data
		$pivoted = $this->get_pivoted_data($form_id);
		$raw_data = $pivoted['raw_data'];
		$all_fields = $pivoted['columns'];
		$num_fields = count($all_fields);
		if (empty($raw_data)) {
			echo json_encode([
				'draw' => intval($this->input->post('draw')),
				'recordsTotal' => 0,
				'recordsFiltered' => 0,
				'aaData' => []
			]);
			return;
		}

		// DataTables parameters
		$draw = intval($this->input->post('draw'));
		$start = intval($this->input->post('start'));
		$length = intval($this->input->post('length'));
		$search_value = $this->input->post('search')['value'] ?? '';
		$order_column_index = intval($this->input->post('order')[0]['column'] ?? 0);
		$order_dir = strtoupper($this->input->post('order')[0]['dir'] ?? 'DESC');

		if ($length == -1) {
			$length = 100;
		}

		$recordsTotal = count($raw_data);

		// Filter
		$filtered_data = [];
		if (empty($search_value)) {
			$filtered_data = $raw_data;
		} else {
			foreach ($raw_data as $row) {
				$searchable = '';
				for ($i = 0; $i <= $num_fields; $i++) { // id + fields
					$cell = $row[$i];
					$searchable .= (is_scalar($cell) ? $cell : '') . ' ';
				}
				$searchable .= $row[$num_fields + 1] ?? ''; // date
				if (stripos($searchable, $search_value) !== false) {
					$filtered_data[] = $row;
				}
			}
		}
		$recordsFiltered = count($filtered_data);

		// Order (exclude action column)
		$date_col = $num_fields + 1;
		$action_col = $date_col + 1;
		if ($order_column_index == $action_col) {
			$order_column_index = 0; // Fallback to ID
		}
		usort($filtered_data, function ($a, $b) use ($order_column_index, $order_dir, $date_col) {
			$val_a = $a[$order_column_index];
			$val_b = $b[$order_column_index];
			if ($order_column_index == $date_col) { // Date column
				$val_a = $val_a ?: '0000-00-00 00:00:00';
				$val_b = $val_b ?: '0000-00-00 00:00:00';
				$ts_a = strtotime($val_a);
				$ts_b = strtotime($val_b);
				$cmp = ($ts_a == $ts_b) ? 0 : (($ts_a < $ts_b) ? -1 : 1);
			} else {
				$cmp = strcmp(is_scalar($val_a) ? $val_a : '', is_scalar($val_b) ? $val_b : '');
			}
			return ($order_dir === 'DESC') ? -$cmp : $cmp;
		});

		// Pagination
		$display_data = array_slice($filtered_data, $start, $length);

		// Build output (use 'data' for standard DataTables, but keep 'aaData' if legacy)
		$output = [
			'draw' => $draw,
			'recordsTotal' => $recordsTotal,
			'recordsFiltered' => $recordsFiltered,
			'data' => [], // Standard
			'aaData' => [] // Legacy compatibility
		];

		foreach ($display_data as $row) {
			$out_row = [];
			// ID
			$out_row[] = '<a href="javascript:void(0)" class="view-submission" data-id="' . html_escape($row[0]) . '">' . html_escape($row[0]) . '</a>';
			// Fields
			for ($i = 1; $i <= $num_fields; $i++) {
				$val = $row[$i];
				$out_row[] = is_scalar($val) ? html_escape($val) : (is_array($val) ? html_escape(json_encode($val)) : '-');
			}
			// Date
			$date_raw = $row[$date_col];
			$out_row[] = $date_raw ? '<span class="text-has-action is-date" data-toggle="tooltip" data-title="' . _dt($date_raw) . '">' . html_escape(time_ago($date_raw)) . '</span>' : '-';
			// Action
			$out_row[] = '<a href="#" class="btn btn-icon view-submission" data-id="' . html_escape($row[0]) . '" data-toggle="tooltip" title="' . _l('view') . '"><i class="fa fa-eye"></i></a>';
			$output['data'][] = $out_row;
			$output['aaData'][] = $out_row; // For compatibility
		}

		echo json_encode($output);
	}
}