<script>
$(function() {
    console.log('Restrict File Upload Module v1.2.1: JavaScript loaded, overriding core file logic');

    // Ensure fbOptions exists
    if (!window.fbOptions) {
        console.error('Restrict File Upload Module: fbOptions is undefined');
        return;
    }

    // Clear existing file event handlers to override core logic
    window.fbOptions.typeUserEvents = window.fbOptions.typeUserEvents || {};
    window.fbOptions.typeUserEvents['file'] = {};

    // New file field event handler (allow multiple file fields)
    window.fbOptions.typeUserEvents['file'] = {
        onadd: function(fId) {
            console.log('Restrict File Upload Module: File field added', fId);
            // Set unique file field name (file-input-N)
            var fieldCount = $('.fb-file input[type="file"]').length;
            var fieldName = 'file-input-' + fieldCount;
            $(fId).find('.name-wrap .input-wrap input').val(fieldName);
            setTimeout(function() {
                $(fId).find('.fb-file input[type="file"]').attr('name', fieldName);
                // Disable multiple file uploads on right-side canvas
                $(fId).find('.fb-file input[type="file"]').removeAttr('multiple');
                console.log('Restrict File Upload Module: File field name set to ' + fieldName + ', multiple attribute removed');
            }, 500);
        },
    };

    // Override core delete button handler
    $('body').off('click', '.del-button').on('click', '.del-button', function() {
        console.log('Restrict File Upload Module: Delete button clicked, overriding core handler');
        var _field = $(this).parents('li.form-field');
        var _preview_name;
        var s = $('.cb-wrap .ui-sortable');

        if (_field.find('.prev-holder input').length > 0) {
            _preview_name = _field.find('.prev-holder input').attr('name');
        } else if (_field.find('.prev-holder textarea').length > 0) {
            _preview_name = _field.find('.prev-holder textarea').attr('name');
        } else if (_field.find('.prev-holder select').length > 0) {
            _preview_name = _field.find('.prev-holder select').attr('name');
        } else if (_field.find('.prev-holder input[type="file"]').length > 0) {
            _preview_name = _field.find('.prev-holder input[type="file"]').attr('name');
            console.log('Restrict File Upload Module: File field deleted', _preview_name);
        }

        var pos = _preview_name ? _preview_name.lastIndexOf('-') : -1;
        _preview_name = _preview_name ? _preview_name.substr(0, pos) : '';

        if (_preview_name && _preview_name !== 'file-input') {
            $('li[data-type="' + _preview_name + '"]').removeClass('disabled');
        }

        setTimeout(function() {
            s.sortable({ cancel: '.disabled' });
            s.sortable('refresh');
            console.log('Restrict File Upload Module: Sortable refreshed');
        }, 80);
    });

    // Override do_form_field_restrictions to prevent disabling file fields
    window.do_form_field_restrictions = function(fId, type) {
        console.log('Restrict File Upload Module: do_form_field_restrictions called for type', type);
        var _field = $(fId);
        var _preview_name;
        var s = $('.cb-wrap .ui-sortable');

        if (type == 'checkbox-group') {
            _preview_name = _field.find('input[type="checkbox"]').eq(0).attr('name');
        } else if (type == 'file') {
            // Do not disable file field in left-side control panel
            _preview_name = _field.find('.fb-file input[type="file"]').attr('name');
        } else {
            var check = _field.find('[type="' + type + '"]');
            if (check.length == 0) {
                check = _field.find(type);
            }
            _preview_name = check.attr('name');
        }

        if (type != 'file') {
            var pos = _preview_name.lastIndexOf('-');
            _preview_name = _preview_name.substr(0, pos);
            $('[data-type="' + _preview_name + '"]:not(.form-field)').addClass('disabled');
        }

        $('.frmb-control li[type="' + _preview_name + '"]').removeClass('text-danger');

        if (typeof(mustRequiredFields) != 'undefined' && $.inArray(_preview_name, mustRequiredFields) != -1) {
            _field.find('.required-wrap input[type="checkbox"]').prop('disabled', true);
        }

        setTimeout(function() {
            s.sortable({ cancel: '.disabled' });
            s.sortable('refresh');
        }, 80);
    };

    // Check existing form data on page load
    if (formData && formData.length) {
        try {
            console.log('Restrict File Upload Module: Checking existing formData, overriding core');
            var parsedFormData = JSON.parse(formData);
            if (parsedFormData.some(field => field.type === 'file')) {
                console.log('Restrict File Upload Module: Existing file field found');
                // Ensure multiple attribute is removed for existing fields
                $('.fb-file input[type="file"]').removeAttr('multiple');
            }
        } catch (e) {
            console.error('Restrict File Upload Module: Error parsing formData:', e);
        }
    }
});
</script>