<?php
defined('BASEPATH') or exit('No direct script access allowed');

/*
Module Name: Restrict File Upload
Description: Overrides web-to-lead form builder to allow dragging multiple file upload fields and prevents multiple file uploads per field
Version: 1.2.1
Requires at least: 2.3.2
*/

define('RESTRICT_FILE_UPLOAD_MODULE_NAME', 'restrict_file_upload');

// Register activation hook
register_activation_hook(RESTRICT_FILE_UPLOAD_MODULE_NAME, 'restrict_file_upload_activation_hook');

// Activation function
function restrict_file_upload_activation_hook() {
    require_once(__DIR__ . '/install.php');
}

// Register language files
register_language_files(RESTRICT_FILE_UPLOAD_MODULE_NAME, ['restrict_file_upload']);

// Inject custom JavaScript into web-to-lead form builder
hooks()->add_action('app_admin_footer', 'restrict_file_upload_add_scripts');
function restrict_file_upload_add_scripts() {
    $ci = &get_instance();
    $uri = $ci->uri->uri_string();
    log_message('debug', 'Restrict File Upload v1.2.1: Checking URI: ' . $uri);

    // Target admin/leads and admin/campaigns
    if (
        strpos($uri, 'admin/leads') !== false ||
        strpos($uri, 'admin/campaigns') !== false
    ) {
        log_message('debug', 'Restrict File Upload v1.2.1: Matched valid URI, loading _form_js_formatter.php');
        try {
            $ci->load->view('restrict_file_upload/_form_js_formatter');
        } catch (Exception $e) {
            log_message('error', 'Restrict File Upload v1.2.1: Error loading view: ' . $e->getMessage());
        }
    } else {
        log_message('debug', 'Restrict File Upload v1.2.1: URI not matched, skipping');
    }
}
