<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<div id="wrapper">
	<div class="content">
		<div class="row">
			<div class="col-md-12">

				<div class="panel_s">
					<div class="panel-body">
						<div class="row">
                            <div class="col-md-6">
                                <h4 class="no-margin font-bold"><i class="fa <?php echo $icon ?>" aria-hidden="true"></i> <?php echo $title; ?></h4>
                            </div>
							<div class="col-md-6 text-right">
								<a href="<?= admin_url('restoration/sub_category/add_edit/0'); ?>" class="btn btn-primary "><?php echo _l('restoration_create'); ?></a>
							</div>
                            <div class="col-md-12">
                                <hr/>
                            </div>
                        </div>
                        <div class="row">
                           <div class="col-md-12">
								<?php
								$table_data = array(
									'Sr. No',
									_l('restoration_sub_category_title'), // Sub Category Title
									_l('restoration_category'), // Parent Category Title
									_l('restoration_table_action'),
								);
								render_datatable($table_data, 'sub_cat_table'); // Changed class name
								?>
						   </div>
                        </div>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>
<?php init_tail(); ?>
<script>
    let arrayArray = [];
    $(function(){
        let fnServerParams = {};
        // Updated URL to point to sub_category controller
        initDataTable('.table-sub_cat_table', admin_url + 'restoration/sub_category/index', [], arrayArray, fnServerParams, [], {
            columns: [
                { data: null }, // Serial number 
                { data: 'sub_cat_title' },
                { data: 'parent_cat_title' },
                { data: null, orderable: false, searchable: false } // Action buttons
            ]
        });
    });

    function delete_task(id){
        if (confirm_delete()) {
            // Updated URL to point to sub_category controller
            $.post(admin_url + 'restoration/sub_category/delete/' + id)
                .done(function (response) {
                    response = JSON.parse(response);
                    if (response.success === true || response.success == 'true') {
                        alert_float('success', response.message); // Changed to success color usually green
                        $(".btn-dt-reload").trigger('click');
                    } else {
                        alert_float('danger', response.message);
                    }
                })
                .fail(function (error) {
                    alert_float('danger', JSON.parse(error.responseText));
                });
        }
    }
</script>
</body>
</html>