<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>

<div id="wrapper">
    <div class="content">
        <div class="row">
            <div class="col-md-12">
                <div class="panel_s">
                    <div class="panel-body">
                        <div class="row">
                            <div class="col-md-12 mb-4">
                                <h3 class="no-margin font-bold"><i class="fa <?php echo $icon ?>" aria-hidden="true"></i> <?php echo $title; ?></h3>
                            </div>
                            <div class="col-md-12">
                                <hr/>
                            </div>
                        </div>
                        <?php echo form_open(admin_url('restoration/sub_category/add_edit'.($id ? '/' . $id : '')), ['id' => 'form_add_edit']); echo form_hidden('id',$id)?>
                            <div class="row">
                                <div class="col-md-6">
                                    <?php 
                                        $selected = (isset($sub_category) ? $sub_category->restoration_category_id : '');
                                        echo render_select('restoration_category_id', $categories, array('id', 'title'), 'restoration_category', $selected); 
                                    ?>
                                </div>
                                <div class="col-md-6">
                                    <?php
                                        $value = (isset($sub_category->title) ? $sub_category->title : '');
                                        echo render_input('title', 'Title', $value, 'text');
                                    ?>
                                </div>
                            </div>
                            <div class="col-md-12 text-right">
                                <a href="<?php echo admin_url('restoration/sub_category') ?>" class="btn btn-default"><?php echo _l('cancel'); ?></a>
                                <button type="submit" class="btn btn-primary"><?php echo _l('save'); ?></button>
                            </div>
                        <?php echo form_close(); ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php init_tail(); ?>
<script>
   
    jQuery(document).ready(() => {
        $("#form_add_edit").appFormValidator({
            rules:{
                title: 'required',
                restoration_category_id: 'required', // Added validation for dropdown
            },
            errorPlacement: function(error, element) {
                $(error).addClass('text-danger');
                error.appendTo( element.parents(".form-group"));
            },
            submitHandler: function(form) {
                add_edit_form_handler(form);
            },
            highlight: function(element, errorClass) {
                $(element).parents('.form-group').addClass("has-error");
            }
        });
    });

    function add_edit_form_handler(form){
        $("#add_loader").removeClass('d-none');
        let formURL = form.action;
        let formData = new FormData($(form)[0]);
        $.ajax({
            type: $(form).attr('method'),
            data: formData,
            mimeType: $(form).attr('enctype'),
            contentType: false,
            cache: false,
            processData: false,
            url: formURL
        }).done(function (response) {
            $("#add_loader").addClass('d-none');
            response = JSON.parse(response);
            if (response.success === true || response.success == 'true') {
                alert_float('success', response.message);
                window.location = admin_url+"restoration/sub_category";
            } else {
                alert_float('danger', response.message);
            }

        }).fail(function (error) {
            alert_float('danger', JSON.parse(error.responseText));
        });

    }
</script>
</body>
</html>