<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>

<div id="wrapper">
    <div class="content">
        <div class="row">
            <div class="col-md-12">
                <div class="panel_s">
                    <div class="panel-body">
                        <div class="row">
                            <div class="col-md-12 mb-4">
                                <h3 class="no-margin font-bold"><i class="fa <?php echo $icon ?>" aria-hidden="true"></i> <?php echo $title; ?></h3>
                            </div>
                            <div class="col-md-12">
                                <hr/>
                            </div>
                        </div>
                        
                        <!-- Updated Action to save_report_type -->
                        <?php echo form_open(admin_url('restoration/report_type/save_report_type'), ['id' => 'form_add_edit']); ?>
                            
                            <!-- Hidden ID Field -->
                            <input type="hidden" name="id" value="<?= $id; ?>">

                            <div class="row">
                                <div class="col-md-12">
                                    <?php
                                        $value = (isset($report_type->title) ? $report_type->title : '');
                                        echo render_input('title', 'restoration_report_type', $value, 'text');
                                    ?>
                                </div>
                            </div>
                            <div class="col-md-12 text-right">
                                <a href="<?php echo admin_url('restoration/report_type') ?>" class="btn btn-default"><?php echo _l('cancel'); ?></a>
                                <button type="submit" class="btn btn-primary"><?php echo _l('save'); ?></button>
                            </div>
                        <?php echo form_close(); ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php init_tail(); ?>
<script>
    jQuery(document).ready(() => {
        $("#form_add_edit").appFormValidator({
            rules:{
                title: 'required',
            },
            errorPlacement: function(error, element) {
                $(error).addClass('text-danger');
                error.appendTo( element.parents(".form-group"));
            },
            // Standard Submit to allow Controller Redirect
            submitHandler: function(form) {
                $("#add_loader").removeClass('d-none');
                form.submit();
            },
            highlight: function(element, errorClass) {
                $(element).parents('.form-group').addClass("has-error");
            }
        });
    });
</script>
</body>
</html>