<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php //init_head(); ?>

<style>
    .img-fluid{
        max-width: 100%;
        height: auto;
    }
    .grade-box {
        max-width: 360px;
        margin: 20px auto;
    }
    .grade-title {
        font-size: 1rem;
        font-weight: 600;
        padding: 10px;
    }
    .grade-score {
        font-size: 1rem;
        font-weight: bold;
        text-align: center;
    }
    .btn-custom {
        font-weight: bold;
        margin-bottom: 10px;
        width: 100%;
    }
    /* Added style for Template Header */
    .template-header {
        background-color: #f8f9fa;
        padding: 10px 15px;
        margin-top: 20px;
        margin-bottom: 10px;
        border-left: 5px solid #03a9f4;
        border-bottom: 1px solid #e0e0e0;
    }
</style>

<!-- <div id="wrapper"> -->
    <div class="content">
        <div class="panel_s">
            <div class="panel-body">

                <div class="row">
                    <div class="col-md-8">
                        <h3 style="margin-top:0px; font-weight:bold; color:#333;">
                            <?= isset($report) ? $report->report_name : 'Project Report'; ?>
                        </h3>
                        <?php if(isset($report)): ?>
                            <span class="label label-info" style="font-size: 90%;"><?= $report->report_type; ?></span>
                            <span class="text-muted" style="margin-left: 10px;">Created: <?= _dt($report->created_at); ?></span>
                        <?php endif; ?>
                    </div>
                    <div class="col-md-4 text-right">
                        <a href="<?= admin_url('restoration/projects/view/'.$project->id.'?group=project_report'); ?>" class="btn btn-default">
                            <i class="fa fa-arrow-left"></i> Back to Reports
                        </a>
                    </div>
                    <div class="col-md-12"><hr/></div>
                </div>
                <div class="tasks-table panel-table-full" id="vueApp">
                    <div class="row">
                        <div class="col-md-3">
                            <table class="table table-bordered w-100">
                                <tbody>
                                    <td>
                                        <h4><?= $project->imo_number ?? ''; ?></h4>
                                        <h4>View/Download Report:</h4>
                                        <a href="<?= admin_url('restoration/projects/download_report_pdf/'.$project->id); ?>" target="_blank">
                                            <button class="btn btn-info w-100 btn-custom"><i class="fas fa-file-pdf" aria-hidden="true"></i> Download PDF</button>
                                        </a>

                                        <h4>Email Report:</h4>
                                        <a href="javascript:void(0);" onclick="$('#sendEmailModal').modal('show');">
                                            <button class="btn btn-success w-100 btn-custom">
                                                <i class="fas fa-file-pdf" aria-hidden="true"></i> Email PDF
                                            </button>
                                        </a>
                                    </td>
                                </tbody>
                            </table>
                        </div>
                        <div class="col-md-9">
                            <?php
                                if($tasks){
                                foreach ($tasks as $key => $task) {
                                    
                                    // NEW: Display Template Name Header
                                    ?>
                                    <div class="template-header">
                                        <h4 class="m-0 text-info bold"><?= isset($task['template_name']) ? $task['template_name'] : ''; ?></h4>
                                    </div>
                                    <?php

                                    if($task["template_table"]){
                                        $template_table = $task["template_table"];
                                        ?>
                                        <table class="table table-bordered w-100">
                                            <tbody>
                                                <?php
                                                    if($template_table){
                                                        foreach ($template_table as $key => $value) {
                                                            ?>
                                                            <tr>
                                                                <td>
                                                                    <?php
                                                                    if($value['field_type'] == 'table'){
                                                                        ?>
                                                                        <table class="table table-bordered">
                                                                            <?php if($value['is_visible_label'] == 1){?>
                                                                            <thead>
                                                                                <tr >
                                                                                    <?php
                                                                                    $columnWidth = 100/count($value["column_data"]);
                                                                                    foreach ($value["column_data"] as $column_key => $column_value) {
                                                                                        ?>
                                                                                        <th style="width: <?= $columnWidth ?>%;" class='bg-primary'><?= $column_value['column']; ?></th>
                                                                                        <?php
                                                                                    }
                                                                                    ?>
                                                                                </tr>
                                                                            </thead>
                                                                            <?php } ?>
                                                                            <tbody>
                                                                                <?php
                                                                                $i = 1;
                                                                                $columnWidth = 100/count($value["column_data"]);
                                                                                while($value['table_row'] >= $i){
                                                                                    $j=0;
                                                                                    ?>
                                                                                    <tr>
                                                                                        <?php
                                                                                        foreach ($value["column_data"] as $column_key => $column_value) {
                                                                                            ?>
                                                                                            <td style="width: <?= $columnWidth ?>%;">
                                                                                            <?php
                                                                                            switch ($column_value['field']) {
                                                                                                case 'fields':
                                                                                                    $selected = isset($value['value_data'][$j][$i])?$value['value_data'][$j][$i]:'';
                                                                                                    switch ($value['row_data'][$j][$i]) {
                                                                                                        case 'textarea':
                                                                                                            echo $value['value_data'][$j][$i];
                                                                                                            break;

                                                                                                        default:
                                                                                                            echo '<p>'.$value['value_data'][$j][$i].'</p>';
                                                                                                            break;

                                                                                                    }
                                                                                                    break;

                                                                                                case 'textarea':
                                                                                                    echo $value['value_data'][$j][$i];
                                                                                                    break;

                                                                                                case 'file':
                                                                                                    echo '<img src="'.site_url('uploads/restoration_template/'.$value['value_data'][$j][$i]).'" class="img-fluid" alt="">';
                                                                                                    break;

                                                                                                default:
                                                                                                    echo '<p>'.$value['value_data'][$j][$i].'</p>';
                                                                                                    break;
                                                                                            }
                                                                                            $j++;
                                                                                            ?>
                                                                                            </td>
                                                                                            <?php
                                                                                        }
                                                                                        ?>
                                                                                    </tr>
                                                                                    <?php
                                                                                    $i++;
                                                                                }
                                                                                ?>
                                                                            </tbody>
                                                                        </table>
                                                                        <?php
                                                                    }else{

                                                                        switch ($value['value_data']) {
                                                                            case 'text':
                                                                                echo render_input('field['.$value["id"].']', '', '', 'text');
                                                                                break;

                                                                            case 'textarea':
                                                                                echo render_textarea('field['.$value["id"].']', '', '', [], [], '', 'tinymce');
                                                                                break;

                                                                            case 'number':
                                                                                echo render_input('field['.$value["id"].']', '', '', 'number');
                                                                                break;

                                                                            case 'file':
                                                                                echo '<div class="form-group">
                                                                                                <input type="file" name="field['.$value["id"].']" class="form-control" id="profile_image">
                                                                                            </div>';
                                                                                break;

                                                                            default:
                                                                                switch ($value["field_type"]) {
                                                                                    case 'textarea':
                                                                                        echo $value['value_data'];
                                                                                        break;

                                                                                    case 'file':
                                                                                        echo '<img src="'.site_url('uploads/restoration_template/'.$value['value_data']).'" class="img-fluid" alt="">';
                                                                                        break;

                                                                                    default:
                                                                                        echo '<p>'.$value['value_data'].'</p>';
                                                                                        break;
                                                                                }
                                                                                break;
                                                                        }

                                                                    }
                                                                    ?>
                                                                </td>
                                                            </tr>
                                                            <?php
                                                        }
                                                    }
                                                    
                                                    ?>
                                                
                                                </tbody>
                                            </table>
                                        <?php
                                    }
                                }
                                
                                // OLD CODE: Staff Notes (Commented Out)
                                /*
                                if ($staff_notes) {
                                    ?>
                                    <table class="table table-bordered">
                                        <tbody>
                                            <tr>
                                                <th class='bg-primary'>Conclusion</th>
                                            </tr>
                                            <tr>
                                                <td><?= $staff_notes; ?></td>
                                            </tr>
                                        </tbody>
                                    </table>
                                    <?php
                                }
                                */

                                // NEW CODE: Report Details
                                if (isset($report->report_detail) && !empty($report->report_detail)) {
                                    ?>
                                    <table class="table table-bordered" style="margin-top: 20px;">
                                        <tbody>
                                            <tr>
                                                <th class='bg-primary'>Report Details / Conclusion</th>
                                            </tr>
                                            <tr>
                                                <td><?= nl2br($report->report_detail); ?></td>
                                            </tr>
                                        </tbody>
                                    </table>
                                    <?php
                                }

                            }else{
                                ?>
                                <p>No report Founds</p>
                                <?php
                            }
                            ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<!-- </div> -->

<div class="modal fade" id="sendEmailModal" tabindex="-1" role="dialog" aria-labelledby="emailModalLabel">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <?php echo form_open_multipart(admin_url('restoration/projects/email_report_pdf'), ['id' => 'form_email_send']);  ?>
                <?= form_hidden('project_id', $project->id); ?>
                <div class="modal-header">
                    <h4 class="modal-title">Send Email</h4>
                    <button type="button" class="close" data-dismiss="modal"><span>&times;</span></button>
                </div>
                <div class="modal-body">
                    <div class="form-group">
                        <?php
                            // We use $client_email variable passed from controller
                            $default_email = isset($client_email->contact_email) ? $client_email->contact_email : '';
                            echo render_input('email', 'Email', $default_email, ''); 
                        ?>
                    </div>
                    <div class="form-group">
                        <?php $restoration_email_subject = get_option('restoration_email_subject')?get_option('restoration_email_subject'):''; ?>
                        <?php echo render_input('subject', 'Subject', $restoration_email_subject, ''); ?>
                    </div>
                    <div class="form-group">
                        <?php $restoration_email_body = get_option('restoration_email_body')?get_option('restoration_email_body'):''; ?>
                        <?php echo render_textarea('body', 'Body', $restoration_email_body, [], [], '', 'tinymce'); ?>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-success">Send Email</button>
                    <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                </div>
            <?php echo form_close(); ?>
        </div>
    </div>
</div>

<?php init_tail(); ?>

<script>
    jQuery(document).ready(() => {
        $("#form_email_send").appFormValidator({
            rules: {
                email:{
                    required: true,
                },
                subject: {
                    required: true,
                    minlength: 3
                },
                body: {
                    required: true,
                    minlength: 5
                }
            },
            errorPlacement: function(error, element) {
                $(error).addClass('text-danger');
                error.appendTo(element.parents(".form-group"));
            },
            submitHandler: function(form) {
                // event.preventDefault(); // handled by appFormValidator usually
                add_edit_form_handler(form);
            },
            highlight: function(element, errorClass) {
                $(element).parents('.form-group').addClass("has-error");
            }
        });
    });

    function add_edit_form_handler(form){
        let formURL = form.action;
        let formData = new FormData($(form)[0]);
        $.ajax({
            type: $(form).attr('method'),
            data: formData,
            mimeType: $(form).attr('enctype'),
            contentType: false,
            cache: false,
            processData: false,
            url: formURL
        }).done(function (response) {
            try {
                response = JSON.parse(response);
            } catch(e) {
                alert_float('danger', 'Parsing error'); 
                return;
            }
            
            if (response.success === true || response.success == 'true') {
                $('#form_email_send')[0].reset();
                $('#sendEmailModal').modal('hide');
                alert_float('success', response.message);
            } else {
                alert_float('danger', response.message);
            }

        }).fail(function (error) {
            alert_float('danger', JSON.parse(error.responseText));
        });
    }
</script>