<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php if (staff_can('create_milestones', 'projects')) { ?>
<a href="#" class="btn btn-primary" onclick="new_milestone();return false;">
    <i class="fa-regular fa-plus tw-mr-1"></i>
    <?= _l('new_milestone'); ?>
</a>
<?php } ?>
<a href="#" class="btn btn-default" onclick="milestones_switch_view(); return false;"><i class="fa fa-th-list"></i></a>
<?php if ($milestones_found) { ?>
<div id="kanban-params" class="pull-right">
    <div class="checkbox">
        <input type="checkbox" value="yes" id="exclude_completed_tasks" name="exclude_completed_tasks" <?php if ($milestones_exclude_completed_tasks) {
            echo ' checked';
        } ?> onclick="window.location.href =
        '<?= admin_url('restoration/projects/view/' . $project->id . '?group=project_milestones&exclude_completed='); ?>'+(this.checked
        ? 'yes' : 'no')">
        <label
            for="exclude_completed_tasks"><?= _l('exclude_completed_tasks') ?></label>
    </div>
    <div class="clearfix"></div>
    <?= form_hidden('project_id', $project->id); ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php if ($milestones_found) { ?>
<div class="project-milestones-kanban tw-mt-0">
    <div class="kan-ban-tab" id="kan-ban-tab" style="overflow:auto;">
        <div class="row">
            <div class="container-fluid">
                <div id="kan-ban"></div>
            </div>
        </div>
    </div>
</div>
<?php } else { ?>
<div class="alert alert-info mtop15 no-mbot">
    <?= _l('no_milestones_found'); ?>
</div>
<?php } ?>
<div id="milestones-table" class="hide tw-mt-5">
    <div class="panel_s panel-table-full">
        <div class="panel-body">
            <?php render_datatable([
                        _l('milestone_name'),
                        _l('milestone_start_date'),
                        _l('milestone_due_date'),
                        _l('milestone_description'),
	 					'Target Geo',  
                        'Target URLs',   
                        'Keyword List', 
                        'Notes & Goals',
						'Attachments',
                    ], 'milestones'); ?>
        </div>
    </div>
</div>
<div class="modal fade" id="milestoneAttachmentModal" tabindex="-1" role="dialog">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">

      <div class="modal-header">
        <h4 class="modal-title">Milestone Attachments</h4>
        <button type="button" class="close" data-dismiss="modal">×</button>
      </div>

      <div class="modal-body" id="milestoneAttachmentContent">
        <div class="text-center">
          <i class="fa fa-spinner fa-spin"></i> Loading...
        </div>
      </div>

      <div class="modal-footer">
        <button class="btn btn-default" data-dismiss="modal">Close</button>
      </div>

    </div>
  </div>
</div>

<?php init_tail(); ?>
<script src="<?= base_url('modules/restoration/assets/js/projects_milestone.js'); ?>"></script>
</body>
</html>
