<?php defined('BASEPATH') or exit('No direct script access allowed'); 

// Helper logic for badges
// 0->pending (Warning), 1-> approved (Success), 2->disapproved (Danger)

// Task Status Badge
$ts_class = 'bg-warning'; 
$ts_text = 'Pending';
if($task['task_status'] == 1) { $ts_class = 'bg-success'; $ts_text = 'Approved'; }
elseif($task['task_status'] == 2) { $ts_class = 'bg-danger'; $ts_text = 'Dis-Approved'; }

// Client Report Badge
$cr_class = 'bg-warning'; 
$cr_text = 'Pending';
if($task['client_report'] == 1) { $cr_class = 'bg-success'; $cr_text = 'Approved'; }
elseif($task['client_report'] == 2) { $cr_class = 'bg-danger'; $cr_text = 'Dis-Approved'; }
?>

<li data-task-id="<?= e($task['id']); ?>" class="task">
    <div class="panel-body" style="padding: 10px;">
        <div class="row">
            <div class="col-md-12">
                
                <p class="tw-text-xs tw-text-neutral-500 tw-mb-1 tw-uppercase tw-font-bold">
                    <?= e($task['category_name']); ?>
                </p>

                <h4 class="tw-text-base tw-my-0 tw-mb-2">
                    <a href="<?= admin_url('restoration/tasks/view/' . $task['id']); ?>" 
                       class="text-dark hover:text-primary"
                       onclick="/* Add your modal init function here if needed */">
                        <?= e($task['task_title']); ?>
                    </a>
                </h4>

                <div class="tw-border-t tw-border-solid tw-border-neutral-200 tw-pt-2 tw-mt-2">
                    <div class="tw-flex tw-justify-between tw-items-center">
                        
                        <div class="tw-flex tw-flex-col">
                            <span class="tw-text-[10px] tw-text-neutral-500">Task Status</span>
                            <span class="badge <?= $ts_class; ?> text-white"><?= $ts_text; ?></span>
                        </div>

                        <div class="tw-flex tw-flex-col tw-items-end">
                            <span class="tw-text-[10px] tw-text-neutral-500">Client Report</span>
                            <span class="badge <?= $cr_class; ?> text-white"><?= $cr_text; ?></span>
                        </div>

                    </div>
                </div>

            </div>
        </div>
    </div>
</li>