<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>

<div class="panel_s">
    <div class="panel-body">
        <?php if (isset($project->settings->hide_tasks_on_main_tasks_table) && $project->settings->hide_tasks_on_main_tasks_table == '1') { ?>
            <i class="fa fa-exclamation fa-2x pull-left" data-toggle="tooltip" data-title="<?= _l('project_hide_tasks_settings_info'); ?>"></i>
        <?php } ?>
        <div class="tasks-table panel-table-full">
            <div class="row">
                <div class="col-md-12">
                    <table class="table table-restoration_tasks">
                        <thead>
                            <tr>
								<th><?= _l('Sr. No.'); ?></th>
                                <th><?= _l('restoration_task_title'); ?></th>
                                <th><?= _l('restoration_task_category'); ?></th>
                                <th><?= _l('Start Date'); ?></th>
                                <th><?= _l('Due Date'); ?></th>
                                <th><?= _l('Assignees'); ?></th>
                                <th><?= _l('Followers'); ?></th>
                                <th><?= _l('Task Status'); ?></th>
                                <th><?= _l('Client Report'); ?></th>
                            </tr>
                        </thead>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
$(document).ready(function() {
    if (!$.fn.DataTable.isDataTable('.table-restoration_tasks')) {
        $('.table-restoration_tasks').DataTable({
            ajax: {
                url: '<?= admin_url('restoration/tasks/table/' . $project->id); ?>',
                type: 'POST',
                data: function(d) {
                    d['<?= $this->security->get_csrf_token_name(); ?>'] = '<?= $this->security->get_csrf_hash(); ?>';
                },
                error: function(xhr, error, thrown) {
                    console.error('AJAX Error:', xhr.responseText);
                    alert('Failed to load table data. Check console for details.');
                }
            },
            columns: [
                { data: 0 }, // Title
                { data: 1 }, // Category
                { data: 2 }, // Start Date
                { data: 3 }, // Due Date
                { data: 4 }, // Assignees
                { data: 5 }, // Followers
                { data: 6 }, // Task Status
                { data: 7 }, // Client Report
                { data: 8 }  // Actions
            ],
            order: [[0, 'asc']],
            columnDefs: [
                { targets: [8], orderable: false, searchable: false } // Disable sorting on action column
            ],
            language: {
                emptyTable: 'No tasks found for this project.'
            }
        });
    }
});
</script>
