<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<style>
    .img-fluid {
        max-width: 100%;
        height: auto;
    }
    .grade-box {
        max-width: 360px;
        margin: 20px auto;
    }
    .grade-title {
        font-size: 1rem;
        font-weight: 600;
        padding: 10px;
    }
    .grade-score {
        font-size: 1rem;
        font-weight: bold;
        text-align: center;
    }
    .btn-custom {
        font-weight: bold;
        margin-bottom: 10px;
        width: 100%;
    }
</style>

<div class="panel_s">
    <div class="panel-body">
        <div class="tasks-table panel-table-full" id="vueApp">
            <div class="row">
                <div class="col-md-3">
                    <table class="table table-bordered w-100">
                        <tbody>
                            <td>
                                <h4><?= $project->imo_number ?? ''; ?></h4>

                                <h4>View/Download Report:</h4>
                                <a href="<?= admin_url('restoration/projects/download_report_pdf/'.$project->id); ?>" target="_blank">
                                    <button class="btn btn-info w-100 btn-custom">
                                        <i class="fas fa-file-pdf" aria-hidden="true"></i> Download PDF
                                    </button>
                                </a>
                            </td>
                        </tbody>
                    </table>
                </div>
                <div class="col-md-9">
                    <?php
                    $staff_notes = $staff_notes ?? '';

                    if ($tasks) {
                        foreach ($tasks as $key => $task) {
                            if (!empty($task["template_table"])) {
                                $template_table = $task["template_table"];
                                ?>
                                <table class="table table-bordered w-100">
                                    <tbody>
                                    <?php
                                    foreach ($template_table as $value) {
                                        ?>
                                        <tr>
                                            <td>
                                                <?php
                                                if ($value['field_type'] === 'table') {
                                                    ?>
                                                    <table class="table table-bordered">
                                                        <?php if (!empty($value['is_visible_label'])) { ?>
                                                        <thead>
                                                            <tr>
                                                                <?php
                                                                $column_count = count($value["column_data"]);
                                                                $columnWidth = $column_count > 0 ? 100 / $column_count : 100;
                                                                foreach ($value["column_data"] as $column_value) {
                                                                    ?>
                                                                    <th style="width: <?= $columnWidth ?>%;" class='bg-primary'>
                                                                        <?= $column_value['column'] ?? ''; ?>
                                                                    </th>
                                                                    <?php
                                                                }
                                                                ?>
                                                            </tr>
                                                        </thead>
                                                        <?php } ?>
                                                      <tbody>
														<?php
														$i = 1;
														$column_count = count($value["column_data"]);
														$columnWidth = $column_count > 0 ? 100 / $column_count : 100;

														while ($i <= ($value['table_row'] ?? 0)) {
															$j = 0;
															?>
															<tr>
																<?php foreach ($value["column_data"] as $column_value) { ?>
																	<td style="width: <?= $columnWidth ?>%;">
																		<?php
																		$field_type = $column_value['field'] ?? '';
																		$selected = $value['value_data'][$j][$i] ?? '';
																		$row_type = $value['row_data'][$j][$i] ?? '';

																		switch ($field_type) {
																			case 'fields':
																				echo $row_type === 'textarea' ? $selected : '<p>' . $selected . '</p>';
																				break;

																			case 'textarea':
																				echo $selected;
																				break;

																			case 'file':
																				if (!empty($selected)) {
																					echo '<img src="' . site_url('uploads/restoration_template/' . $selected) . '" class="img-fluid" alt="File">';
																				}
																				break;

																			default:
																				echo '<p>' . $selected . '</p>';
																				break;
																		}
																		$j++;
																		?>
																	</td>
																<?php } ?>
															</tr>
															<?php
															$i++;
														}
														?>
													</tbody>

                                                    </table>
                                                    <?php
                                                } else {
                                                    $val = $value['value_data'] ?? '';
                                                    switch ($val) {
                                                        case 'text':
                                                            echo render_input('field['.$value["id"].']', '', '', 'text');
                                                            break;
                                                        case 'textarea':
                                                            echo render_textarea('field['.$value["id"].']', '', '', [], [], '', 'tinymce');
                                                            break;
                                                        case 'number':
                                                            echo render_input('field['.$value["id"].']', '', '', 'number');
                                                            break;
                                                        case 'file':
                                                            echo '<div class="form-group">
                                                                    <input type="file" name="field['.$value["id"].']" class="form-control" id="profile_image">
                                                                </div>';
                                                            break;
                                                        default:
                                                            switch ($value["field_type"]) {
                                                                case 'textarea':
                                                                    echo $val;
                                                                    break;
                                                                case 'file':
                                                                    if (!empty($val)) {
                                                                        echo '<img src="'.site_url('uploads/restoration_template/'.$val).'" class="img-fluid" alt="File">';
                                                                    }
                                                                    break;
                                                                default:
                                                                    echo '<p>' . $val . '</p>';
                                                                    break;
                                                            }
                                                            break;
                                                    }
                                                }
                                                ?>
                                            </td>
                                        </tr>
                                        <?php
                                    }

                                    if (!empty($staff_notes)) {
                                        ?>
                                        <tr>
                                            <td>
                                                <table class="table table-bordered">
                                                    <tbody>
                                                        <tr>
                                                            <th class='bg-primary'>Conclusion</th>
                                                        </tr>
                                                        <tr>
                                                            <td><?= $staff_notes; ?></td>
                                                        </tr>
                                                    </tbody>
                                                </table>
                                            </td>
                                        </tr>
                                        <?php
                                    }
                                    ?>
                                    </tbody>
                                </table>
                                <?php
                            }
                        }
                    } else {
                        echo '<p>No report found.</p>';
                    }
                    ?>
                </div>
            </div>
        </div>
    </div>
</div>
