<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Sub_category extends AdminController
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model('restoration/sub_category_model');
        // Load category model to populate the dropdown
        $this->load->model('restoration/category_model'); 
    }

    public function index()
    {
        if ($this->input->is_ajax_request()) {
            $select = [
                RESTORATION_TABLE_SUB_CATEGORY . '.title as sub_cat_title',
                RESTORATION_TABLE_CATEGORY . '.title as parent_cat_title',
            ];
            
            $where = [];

            $aColumns = $select;
            $aAdditionalSelect = [RESTORATION_TABLE_SUB_CATEGORY . '.id'];
            $sIndexColumn = 'id';
            $sTable = RESTORATION_TABLE_SUB_CATEGORY;
            
            // Join with the main Category table
            $join = [
                'LEFT JOIN ' . RESTORATION_TABLE_CATEGORY . ' ON ' . RESTORATION_TABLE_CATEGORY . '.id = ' . RESTORATION_TABLE_SUB_CATEGORY . '.restoration_category_id'
            ];

            $result = data_tables_init($aColumns, $sIndexColumn, $sTable, $join, $where, $aAdditionalSelect);

            $output = $result['output'];
            $rResult = $result['rResult'];

            $start = $this->input->post('start') ? $this->input->post('start') : 0;

            foreach ($rResult as $key => $aRow) {
                $row = [];
                $rowOption = [];
                $rowOption[] = '<a href="'.admin_url('restoration/sub_category/add_edit/'.$aRow['id']).'" >' . _l('restoration_edit') . '</a>';
                $rowOption[] = '<a href="!#" onclick="delete_task(\'' . $aRow['id'] . '\'); return false;" class="text-danger">' . _l('restoration_delete') . '</a>';

                // Serial number
                $row[] = $start + $key + 1; 
                // Sub Category Title
                $row[] = $aRow['sub_cat_title'];
                // Parent Category Title
                $row[] = $aRow['parent_cat_title'];
                // Actions
                $row[] = implode(' | ', $rowOption);
                
                $output['aaData'][] = $row;
            }

            echo json_encode($output);
            die();
        }

        $data = [];
        $data['title'] = _l('restoration_sub_category'); // Ensure you add this translation key
        $data['icon'] = 'fa-list-alt'; // Changed icon to distinguish
        
        $this->load->view('restoration/sub_category/index', $data);
    }

    public function add_edit(int $id = 0): void
    {
		
       $id = (int)$id;

        if ($this->input->post()) {
			
            $data = $this->input->post();
            try {
                $success = true;
                if ($id) {
                    $this->sub_category_model->update($id, $data);
                    $message = _l('restoration_sub_category') . ' ' . _l('restoration_updated_successfully');
                } else {
                    $this->sub_category_model->add($data);
                    $message = _l('restoration_sub_category') . ' ' . _l('restoration_added_successfully') ;
                }
            } catch (\Exception $e) {
                $success = false;
                $message = _l('restoration_server_error');
            }

            echo json_encode([
                'success' => $success,
                'message' => $message,
            ]);

            die;
        }

        $data = [];
        
        // Fetch all parent categories for the dropdown
        $data['categories'] = $this->category_model->get_for_dropdown(); 

        if ($id > 0) {
            $data['sub_category'] = $this->sub_category_model->get_for_dropdown($id);
            $title = _l('edit').' '.$data['sub_category']->title;
        } else {
            $title = _l('add_new');
        }

        $data['id'] = $id;
        $data['title'] = $title;
        $data['icon'] = 'fa-pencil';
		
        $this->load->view('restoration/sub_category/add_edit', $data);
    }

    public function delete($id){
        $id = (int)$id;
        if ($this->input->is_ajax_request() && $id) {
            $success = false;
            $message = _l('restoration_something_went_wrong');
            try {
                $total_rows = $this->sub_category_model->get($id);
                if($total_rows){
                    $this->sub_category_model->delete($id);
                    $success = true;
                    $message = _l('restoration_deleted_successfully', _l('restoration_sub_category'));
                }
            } catch (\Exception $e) {
                $success = false;
                $message = _l('restoration_server_error');
            }
            echo json_encode([
                'success' => $success,
                'message' => $message,
            ]);
            die;
        }
    }
}