<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Report_type extends AdminController
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model('restoration/report_type_model');
    }

    public function index()
    {
        if ($this->input->is_ajax_request()) {
            $select = [
                'title',
                'created_at'
            ];
            
            $where = [];

            $aColumns = $select;
            $aAdditionalSelect = ['id'];
            $sIndexColumn = 'id';
            $sTable = RESTORATION_TABLE_REPORT_TYPE;
            
            $join = [];

            $result = data_tables_init($aColumns, $sIndexColumn, $sTable, $join, $where, $aAdditionalSelect);

            $output = $result['output'];
            $rResult = $result['rResult'];

            $start = $this->input->post('start') ? $this->input->post('start') : 0;

            foreach ($rResult as $key => $aRow) {
                $row = [];
                $rowOption = [];
                $rowOption[] = '<a href="'.admin_url('restoration/report_type/add_edit/'.$aRow['id']).'" >' . _l('restoration_edit') . '</a>';
                $rowOption[] = '<a href="!#" onclick="delete_task(\'' . $aRow['id'] . '\'); return false;" class="text-danger">' . _l('restoration_delete') . '</a>';

                // Serial number
                $row[] = $start + $key + 1; 
                // Report Type Title
                $row[] = $aRow['title'];
                // Created At
                $row[] = _dt($aRow['created_at']);
                // Actions
                $row[] = implode(' | ', $rowOption);
                
                $output['aaData'][] = $row;
            }

            echo json_encode($output);
            die();
        }

        $data = [];
        $data['title'] = _l('restoration_report_type'); 
        $data['icon'] = 'fa-file-text-o'; 
        
        $this->load->view('restoration/report_type/index', $data);
    }

    public function add_edit(int $id = 0): void
    {
        $id = (int)$id;

		
        if ($this->input->post()) {
            
            $data = $this->input->post();
            try {
                $success = true;
                if ($id) {
                    $this->report_type_model->update($id, $data);
                    $message = _l('restoration_report_type') . ' ' . _l('restoration_updated_successfully');
                } else {

                    $this->report_type_model->add($data);
					
                    $message = _l('restoration_report_type') . ' ' . _l('restoration_added_successfully') ;
                }
            } catch (\Exception $e) {
                $success = false;
                $message = _l('restoration_server_error');
            }

            echo json_encode([
                'success' => $success,
                'message' => $message,
            ]);

            die;
        }

        $data = [];
        
        if ($id > 0) {
            $data['report_type'] = $this->report_type_model->get_for_dropdown($id);
            $title = _l('edit').' '.$data['report_type']->title;
        } else {
            $title = _l('add_new');
        }

        $data['id'] = $id;
        $data['title'] = $title;
        $data['icon'] = 'fa-pencil';
        
        $this->load->view('restoration/report_type/add_edit', $data);
    }

	public function save_report_type()
    {
        $data = $this->input->post();

        // Check if we are Updating (ID exists and is not 0)
        if (isset($data['id']) && $data['id'] != 0) {
            
            $update = [
                'title' => $data['title'],
                // 'updated_at' => date('Y-m-d H:i:s') // Uncomment if you added this column
            ];

            $this->db->where('id', $data['id']);
            $this->db->update(RESTORATION_TABLE_REPORT_TYPE, $update);

            set_alert('success', "Report Type updated successfully");

        } else {
            
            // Insert (Create New)
            $insert = [
                'title'      => $data['title'],
                'created_at' => date('Y-m-d H:i:s')
            ];

            $this->db->insert(RESTORATION_TABLE_REPORT_TYPE, $insert);

            set_alert('success', "Report Type created successfully");
        }

        redirect(admin_url('restoration/report_type'));
    }
	
    public function delete($id){
        $id = (int)$id;
        if ($this->input->is_ajax_request() && $id) {
            $success = false;
            $message = _l('restoration_something_went_wrong');
            try {
                $total_rows = $this->report_type_model->get($id);
                if($total_rows){
                    $this->report_type_model->delete($id);
                    $success = true;
                    $message = _l('restoration_deleted_successfully', _l('restoration_report_type'));
                }
            } catch (\Exception $e) {
                $success = false;
                $message = _l('restoration_server_error');
            }
            echo json_encode([
                'success' => $success,
                'message' => $message,
            ]);
            die;
        }
    }
}