<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Category extends AdminController
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model('restoration/category_model');
        $this->load->model('restoration/task_model');
    }

    public function index()
    {
        if ($this->input->is_ajax_request()) {
            $select = [
                'title',
            ];
            
            $where = [];
            // $where[] = 'AND item_type = "' . $itemType . '" ';
            // if($this->input->post('item_title')){
            //     $where[] = 'AND item_title LIKE "%' . $this->input->post('item_title') . '%" ';    
            // }

            $aColumns = $select;
            $aAdditionalSelect = ['id'];
            $sIndexColumn = 'id';
            $sTable = RESTORATION_TABLE_CATEGORY;
            $join = [];
            $result = data_tables_init($aColumns, $sIndexColumn, $sTable, $join, $where, $aAdditionalSelect);

            $output = $result['output'];
            $rResult = $result['rResult'];

            // Get the start index for pagination
            $start = $this->input->post('start') ? $this->input->post('start') : 0;

            foreach ($rResult as $key => $aRow) {
                $row = [];
                $rowOption = [];
                $rowOption[] = '<a href="'.admin_url('restoration/category/add_edit/'.$aRow['id']).'" >' . _l('restoration_edit') . '</a>';
                $rowOption[] = '<a href="!#" onclick="delete_task(\'' . $aRow['id'] . '\'); return false;" class="text-danger">' . _l('restoration_delete') . '</a>';

                // Add serial number, title, and action columns
                $row[] = $start + $key + 1; // Serial number
                $row[] = $aRow['title'];
                $row[] = implode(' | ', $rowOption);
                $output['aaData'][] = $row;
            }

            echo json_encode($output);
            die();
        }

        $data = [];
        $data['title'] = _l('restoration_category');
        $data['icon'] = 'fa-users';
        
        $this->load->view('restoration/category/index', $data);
    }
    public function add_edit(int $id = 0): void
    {
       $id = (int)$id;

        if ($this->input->post()) {

            $data = $this->input->post();
            try {
                $success = true;
                if ($id) {
                    $this->category_model->update($id, $data);
                    $message = _l('restoration_category') . _l('restoration_updated_successfully');
                } else {
                    $this->category_model->add($data);
                    $message = _l('restoration_category') . _l('restoration_added_successfully') ;
                }
            } catch (\Exception $e) {
                $success = false;
                $message = _l('restoration_server_error');
            }

            echo json_encode([
                'success' => $success,
                'message' => $message,
            ]);

            die;
        }

        $data = [];
        if ($id > 0) {
            $data['category'] = $this->category_model->get($id);
            $title = _l('edit').' '.$data['category']->title;
        } else {
            $title = _l('add_new');
        }

        $data['id'] = $id;
        $data['title'] = $title;
        $data['icon'] = 'fa-pencil';
        $this->load->view('category/add_edit', $data);
    }

    public function delete($id){
        $id = (int)$id;
        if ($this->input->is_ajax_request() && $id) {
            $success = false;
            $message = _l('restoration_something_went_wrong');
            try {
                $total_rows = $this->category_model->get($id);
                if($total_rows){
                    $this->category_model->delete($id);
                    $success = true;
                    $message = _l('restoration_deleted_successfully', _l('restoration_category'));
                }
            } catch (\Exception $e) {
                $success = false;
                $message = _l('restoration_server_error');
            }
            echo json_encode([
                'success' => $success,
                'message' => $message,
            ]);
            die;
        }
    }


}