<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Canvas extends AdminController {

    public function __construct()
    {
        parent::__construct();
        $this->load->model('restoration/template_table_model');
    }

    // Display the Canvas page
    public function index($id)
    {
        $data['template_id'] = $id;
        $this->load->view('canvas/canvas_view', $data);
    }

    // Save the image from canvas
    public function save_image()
    {
        // Ensure that the input data is not null and that it has the "image" property
        if (!isset($_POST['image'])) {
            echo json_encode(['success' => false, 'message' => 'Invalid image data.']);
            return;
        }

        $image = $_POST['image'];
        $template_id = $this->input->post('template_id');

        // Remove the base64 prefix if it exists
        $image = str_replace('data:image/png;base64,', '', $image);
        $image = str_replace(' ', '+', $image); // Ensure spaces are replaced with "+" for valid base64

        // Decode the base64 string
        $data = base64_decode($image);

        // Check if the data is valid
        if ($data === false) {
            echo json_encode(['success' => false, 'message' => 'Invalid base64 data.']);
            exit;
        }

        // Set the upload directory
        $upload_path = 'uploads/restoration_template/'; // Change this to your desired directory

        // Ensure the upload directory exists
        if (!is_dir($upload_path)) {
            mkdir($upload_path, 0755, true);
        }

        // Generate a unique file name
        $file_name = uniqid('img_', true).'.png'; // Change file extension if needed (e.g., jpg, jpeg)
        $file_path = $upload_path . $file_name;

        // Save the image to the server
        if (file_put_contents($file_path, $data) === false) {
            echo json_encode(['success' => false, 'message' => 'Failed to save the image.']);
            exit;
        }

        $template_table_arr = array(
            "template_id" => $template_id,
            "field_label" => "Canvas Image",
            "field_type" => "file",
            "row_data" => json_encode($file_name),
            "value_data" => json_encode($file_name),
            'is_visible_label' => 0,
        );
        $this->template_table_model->add($template_table_arr);

        // Return the result as JSON
        echo json_encode(['success' => true,  'message' => 'Success to save the image.', 'filename' => $file_name]);
    }

}
