// Fix for shortcuts in discussions textarea/contenteditable - jquery-comments plugin
var $discussionsContentEditable = $(
  "#project_file_data, #discussion-comments"
);
$discussionsContentEditable.on(
  "focus",
  '[contenteditable="true"]',
  function () {
    $.Shortcuts.stop();
  }
);

$discussionsContentEditable.on(
  "focusout",
  '[contenteditable="true"]',
  function () {
    $.Shortcuts.start();
  }
);

$("body").on("show.bs.modal", "._project_file", function () {
  discussion_comments("#project-file-discussion", discussion_id, "file");
});

// --- UPDATED URL HERE ---
initDataTable(
  ".table-project-discussions",
  admin_url + "restoration/projects/discussions/" + project_id, // Changed path
  undefined,
  undefined,
  "undefined",
  [1, "desc"]
);

appValidateForm(
  $("#discussion_form"),
  {
    subject: "required",
  },
  manage_discussion
);

$("#discussion").on("hidden.bs.modal", function (event) {
  var $d = $("#discussion");
  $d.find('input[name="id"]').remove();
  $d.find('input[name="subject"]').val("");
  $d.find('textarea[name="description"]').val("");
  $d.find('input[name="show_to_customer"]').prop("checked", true);
  $d.find(".add-title").removeClass("hide");
  $d.find(".edit-title").removeClass("hide");
});

function manage_discussion(form) {
  var data = $(form).serialize();
  var url = form.action;
  $.post(url, data).done(function (response) {
    response = JSON.parse(response);
    if (response.success == true) {
      alert_float("success", response.message);
    }
    $(".table-project-discussions").DataTable().ajax.reload(null, false);
    $("#discussion").modal("hide");
    $("#discussion_form").find('button[type="submit"]').button("reset");
  });
  return false;
}

function new_discussion() {
  $("#discussion").modal("show");
  $("#discussion .edit-title").addClass("hide");
}

function edit_discussion(invoker, id) {
  $("#additional_discussion").append(hidden_input("id", id));
  $('#discussion input[name="subject"]').val($(invoker).data("subject"));
  $('#discussion textarea[name="description"]').val(
    $(invoker).data("description")
  );
  var checked = $(invoker).data("show-to-customer") == 0 ? false : true;
  $('#discussion input[name="show_to_customer"]').prop("checked", checked);
  $("#discussion").modal("show");
  $("#discussion .add-title").addClass("hide");
}

function delete_project_discussion(id) {
  if (confirm_delete()) {
    // --- UPDATED URL HERE ---
    requestGetJSON("restoration/projects/delete_discussion/" + id).done(function (
      response
    ) {
      alert_float(response.alert_type, response.message);
      $(".table-project-discussions").DataTable().ajax.reload(null, false);
    });
  }
}