<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo htmlspecialchars($product->product_name); ?></title>

    <!-- Bootstrap -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600;700&display=swap" rel="stylesheet">

    <!-- Enhanced Professional Design -->
    <style>
        * { box-sizing: border-box; }
        body {
            background: #f6f8fb !important;
            font-family: "Poppins", "Segoe UI", Roboto, sans-serif;
            color: #2c2c2c;
            <?php if (!empty($with_logo)): ?>padding-top: 80px;<?php endif; ?>
        }

        <?php if (!empty($with_logo)): ?>
        .logo-fixed {
            position: fixed;
            top: 15px;
            left: 50%;
            transform: translateX(-50%);
            background: #ffffff;
            border-radius: 10px;
            box-shadow: 0 2px 16px rgba(0,0,0,0.1);
            z-index: 1055;
            max-width: 160px;
            padding: 10px 20px;
        }
        <?php endif; ?>

        /* Product Containers */
        .product-gallery, .product-details {
            background: #fff;
            border-radius: 12px;
            box-shadow: 0 4px 24px rgba(0,0,0,0.05);
            padding: 24px;
            margin-bottom: 20px;
        }

        /* Product Gallery */
        .product-gallery {
            position: relative;
        }
        .main-image {
            width: 100%;
            height: 420px;
            object-fit: contain;
            border-radius: 10px;
            background: #fafafa;
            border: 1px solid #e9ecef;
            transition: transform 0.25s ease-in-out;
        }
        .main-image:hover { transform: scale(1.03); }

        .thumbnails {
            display: flex;
            gap: 10px;
            justify-content: center;
            margin-top: 12px;
            flex-wrap: wrap;
        }
        .thumbnail {
            width: 70px;
            height: 70px;
            border-radius: 8px;
            object-fit: cover;
            border: 2px solid transparent;
            background: #fff;
            transition: 0.3s;
            cursor: pointer;
        }
        .thumbnail.active, .thumbnail:hover {
            border-color: #007bff;
            box-shadow: 0 0 0 3px rgba(0,123,255,0.1);
        }

        /* Navigation Arrows */
        .nav-arrow {
            position: absolute;
            top: 48%;
            transform: translateY(-50%);
            background: rgba(0,123,255,0.85);
            color: #fff;
            border: none;
            border-radius: 50%;
            width: 40px;
            height: 40px;
            font-size: 22px;
            display: flex;
            align-items: center;
            justify-content: center;
            transition: all 0.2s ease;
        }
        .nav-arrow:hover { background: #0056b3; }
        .nav-prev { left: 10px; }
        .nav-next { right: 10px; }

        /* Product Details */
        .product-title {
            font-size: 2.2rem;
            font-weight: 700;
            color: #212529;
            margin-bottom: 0.5rem;
        }
        .text-muted small a {
            color: #007bff;
            text-decoration: none;
        }
        .text-muted small a:hover {
            text-decoration: underline;
        }

        .product-price {
            font-size: 2rem;
            font-weight: 700;
            color: #198754;
            margin-bottom: 1rem;
        }

        .product-description {
            color: #555;
            font-size: 1.05rem;
            line-height: 1.7;
        }

        .product-actions .btn {
            font-size: 1.1rem;
            padding: 10px 26px;
            border-radius: 8px;
            transition: 0.2s ease-in-out;
        }
        .btn-primary {
            background: linear-gradient(135deg, #007bff, #0056b3);
            border: none;
            color: #fff;
        }
        .btn-primary:hover { background: linear-gradient(135deg, #0069d9, #004085); }
        .btn-outline-secondary {
            border-color: #ccc;
            color: #333;
            background: #fafafa;
        }
        .btn-outline-secondary:hover {
            background: #e9ecef;
            border-color: #999;
        }

        /* Product Description Section */
        .product-description-section {
            background: #fff;
            border-radius: 12px;
            box-shadow: 0 2px 16px rgba(0,0,0,0.05);
            padding: 25px;
            margin-top: 25px;
        }
        .product-description-section h5 {
            font-weight: 600;
            color: #212529;
            margin-bottom: 12px;
        }

        /* Reviews Section */
        .reviews-scrollable {
            max-height: 300px;
            overflow-y: auto;
            padding-right: 8px;
        }
        .reviews-scrollable::-webkit-scrollbar {
            width: 8px;
        }
        .reviews-scrollable::-webkit-scrollbar-thumb {
            background-color: #ccc;
            border-radius: 10px;
        }
        .reviews-scrollable::-webkit-scrollbar-thumb:hover {
            background-color: #999;
        }

        /* Modal Styling */
        .modal-content {
            border-radius: 10px;
            box-shadow: 0 6px 24px rgba(0,0,0,0.1);
        }
        .modal-header {
            background: #f8f9fa;
            border-bottom: 1px solid #dee2e6;
        }
        .modal-title {
            font-weight: 600;
            color: #212529;
        }
        .modal-footer .btn-primary {
            background: #0d6efd;
            border: none;
        }

        /* Responsive Design */
        @media (max-width: 991.98px) {
            .main-image { height: 300px; }
            .product-title { font-size: 1.7rem; }
            .product-price { font-size: 1.7rem; }
        }

        @media (max-width: 767.98px) {
            body { padding-top: <?php echo !empty($with_logo) ? '120px' : '20px'; ?>; }
            .product-gallery, .product-details, .product-description-section {
                padding: 16px;
            }
            .main-image { height: 220px; }
            .thumbnails { flex-wrap: wrap; gap: 6px; }
            .thumbnail { width: 55px; height: 55px; }
            .product-title { font-size: 1.5rem; }
            .product-actions .btn { width: 100%; font-size: 1rem; }
        }

        @media (max-width: 480px) {
            .main-image { height: 180px; }
        }
    </style>
</head>

<body class="bg-light">

<?php
$category_name = '';
if (isset($product_categories) && !empty($product->product_category_id)) {
    foreach ($product_categories as $cat) {
        if (isset($cat['p_category_id']) && $cat['p_category_id'] == $product->product_category_id) {
            $category_name = $cat['p_category_name'];
            break;
        }
    }
}
$is_logged_in = isset($is_logged_in) ? $is_logged_in : false;
$login_url = 'https://app.xtrazcon.com/authentication/login';
$add_to_cart_url = base_url('cart/add/' . $product->id);
?>

<div class="container py-4">
    <div class="row">
        <div class="col-lg-5 col-md-6">
            <div class="product-gallery">
                <?php
                $images = [];
                if (!empty($product->product_image)) {
                    $decoded = @json_decode($product->product_image);
                    $images = (json_last_error() === JSON_ERROR_NONE && is_array($decoded)) ? array_filter($decoded) : [$product->product_image];
                }
                $image_paths = array_map(fn($i) => base_url('modules/products/uploads/' . $i), $images);
                $main_image = $image_paths[0] ?? '';
                ?>
                <?php if (!empty($main_image)): ?>
                    <img src="<?php echo $main_image; ?>" id="mainImage" class="main-image img-fluid rounded" alt="<?php echo htmlspecialchars($product->product_name); ?>">
                    <?php if (count($image_paths) > 1): ?>
                        <button class="nav-arrow nav-prev" onclick="changeImage(-1)">‹</button>
                        <button class="nav-arrow nav-next" onclick="changeImage(1)">›</button>
                    <?php endif; ?>
                <?php endif; ?>
                <?php if (count($image_paths) > 1): ?>
                    <div class="thumbnails">
                        <?php foreach ($image_paths as $index => $path): ?>
                            <img src="<?php echo $path; ?>" class="thumbnail <?php echo $index === 0 ? 'active' : ''; ?>" onclick="changeMainImage(<?php echo $index; ?>)">
                        <?php endforeach; ?>
                    </div>
                <?php endif; ?>
            </div>
        </div>

        <div class="col-lg-7 col-md-6">
            <div class="product-details">
                <h1 class="product-title"><?php echo htmlspecialchars($product->product_name); ?></h1>
                <?php if (!empty($category_name)): ?>
                    <p class="text-muted mb-3">
                        <small>Category: <a href="<?php echo base_url('products?category=' . $product->product_category_id); ?>"><?php echo htmlspecialchars($category_name); ?></a></small>
                    </p>
                <?php endif; ?>
                <div class="mb-3">
                    <span class="product-price"><?php echo app_format_money($product->rate, $base_currency->name); ?></span>
                </div>
                <?php if ($product->is_variation): ?>
                    <p class="mb-3"><small class="text-muted">Variations: <?php echo get_product_variation_values($product->id); ?></small></p>
                <?php endif; ?>
                <div class="product-actions mb-3">
                    <?php if ($is_logged_in): ?>
                        <a href="<?php echo $add_to_cart_url; ?>" class="btn btn-primary me-md-2">Buy Now</a>
                    <?php else: ?>
                        <a href="<?php echo $login_url . (strpos($login_url, '?') !== false ? '&' : '?') . 'redirect=' . urlencode(current_url()); ?>" class="btn btn-primary me-md-2">Buy Now</a>
                    <?php endif; ?>
                    <button class="btn btn-outline-secondary" data-bs-toggle="modal" data-bs-target="#queryModal">Query For Product</button>
                </div>
                <?php if (!empty($product->product_short_description)): ?>
                    <p class="text-secondary mb-3"><?php echo htmlspecialchars($product->product_short_description); ?></p>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <div class="product-description-section">
        <?php
        $full_description = html_entity_decode($product->product_description ?? '');
        $plain_text = strip_tags($full_description);
        $words = preg_split('/\s+/', trim($plain_text));
        $word_count = count($words);
        if ($word_count > 100) {
            $truncated_words = array_slice($words, 0, 100);
            $truncated = implode(' ', $truncated_words) . '...';
            echo '<h5>Product Description</h5>';
            echo '<p class="product-description mb-2" id="desc-preview">' . htmlspecialchars($truncated) . ' <button type="button" class="btn btn-link p-0 text-decoration-none" onclick="showFullDesc()">See More</button></p>';
            echo '<div id="full-desc" style="display: none;"><p class="product-description">' . $full_description . '</p></div>';
        } else {
            echo '<h5>Product Description</h5>';
            echo '<p class="product-description">' . $full_description . '</p>';
        }
        ?>
	</div>
	<div class="product-description-section">
        <?php
        if (!empty($product->reviews)) {
            $reviews = json_decode($product->reviews, true);
            if (json_last_error() === JSON_ERROR_NONE && is_array($reviews) && count($reviews) > 0) {
                $review_count = count($reviews);
                $scroll_class = $review_count > 3 ? 'reviews-scrollable' : '';
                echo '<div class="mt-4">';
                echo '<h5><i class="fa fa-star text-warning"></i> Product Reviews</h5>';
                echo '<div class="'.$scroll_class.'">';
                foreach ($reviews as $idx => $review) {
                    $stars = (int)($review['review_star'] ?? 0);
                    $stars_html = str_repeat('★', $stars) . str_repeat('☆', 5 - $stars);
                    echo '<div class="border-bottom pb-2 mb-2">';
                    echo '<p class="mb-1 text-warning" style="font-size:1.2rem;">'.$stars_html.'</p>';
                    echo '<p class="text-muted">'.nl2br(htmlspecialchars($review['review_details'] ?? '')).'</p>';
                    echo '</div>';
                }
                echo '</div></div>';
            }
        }
        ?>
    </div>
</div>

<!-- Query Modal -->
<div class="modal fade" id="queryModal" tabindex="-1" aria-labelledby="queryModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="queryModalLabel">Query For: <?php echo htmlspecialchars($product->product_name); ?></h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <?php echo form_open('products/query'); ?>
            <div class="modal-body">
                <input type="hidden" name="product_id" value="<?php echo $product->id; ?>">
                <input type="hidden" name="referrer_url" value="<?php echo current_url(); ?>">
                <div class="mb-3">
                    <label class="form-label">Name</label>
                    <input type="text" class="form-control" name="name" required>
                </div>
                <div class="mb-3">
                    <label class="form-label">Email</label>
                    <input type="email" class="form-control" name="email" required>
                </div>
                <div class="mb-3">
                    <label class="form-label">Phone Number</label>
                    <input type="tel" class="form-control" name="phone" required>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                <button type="submit" class="btn btn-primary">Submit Query</button>
            </div>
            <?php echo form_close(); ?>
        </div>
    </div>
</div>

<!-- Scripts -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script>
    const imagePaths = <?php echo json_encode($image_paths); ?>;
    let currentIndex = 0;
    function changeMainImage(index) {
        if (index >= 0 && index < imagePaths.length) {
            currentIndex = index;
            document.getElementById('mainImage').src = imagePaths[currentIndex];
            updateActiveThumbnail();
        }
    }
    function changeImage(direction) {
        const newIndex = (currentIndex + direction + imagePaths.length) % imagePaths.length;
        changeMainImage(newIndex);
    }
    function updateActiveThumbnail() {
        document.querySelectorAll('.thumbnail').forEach((thumb, index) => {
            thumb.classList.toggle('active', index === currentIndex);
        });
    }
    function showFullDesc() {
        document.getElementById('desc-preview').style.display = 'none';
        document.getElementById('full-desc').style.display = 'block';
    }
    document.addEventListener('DOMContentLoaded', updateActiveThumbnail);
</script>

</body>
</html>
