<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Products Grid</title>

    <!-- Always include Bootstrap and logo if styled -->
    <?php if (isset($styled) && $styled): ?>
        <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
        <?php if (isset($with_logo) && $with_logo): ?>
            <style>
                body { padding: 20px; }
                .logo { max-width: 150px; }
            </style>
            <img src="<?php echo base_url('assets/images/logo.png'); ?>" alt="Logo" class="logo mb-3 mx-auto d-block">
        <?php endif; ?>
    <?php endif; ?>
</head>

<body<?php echo (isset($styled) && $styled) ? ' class="bg-light"' : ''; ?>>
    <div class="container<?php echo (isset($styled) && $styled) ? '' : ' p-0'; ?>">
        <div class="row g-3">
            <?php if (empty($products)): ?>
                <div class="col-12"><p class="text-center">No products found.</p></div>
            <?php else: ?>
                <?php foreach ($products as $p): ?>
                    <?php
                        // Handle multiple images (JSON or string)
                        $first_image = '';
                        if (!empty($p['product_image'])) {
                            $decoded = @json_decode($p['product_image'], true);
                            if (json_last_error() === JSON_ERROR_NONE && is_array($decoded) && count($decoded) > 0) {
                                $first_image = $decoded[0]; // First image from JSON array
                            } else {
                                $first_image = $p['product_image']; // Single image fallback
                            }
                        }
                    ?>
                    <div class="col-md-4 col-sm-6">
                        <div class="card h-100<?php echo (isset($styled) && $styled) ? '' : ' border-0 shadow-none'; ?>">
                            <?php if (!empty($first_image)): ?>
                                <img src="<?php echo base_url('modules/products/uploads/' . $first_image); ?>"
                                     class="card-img-top<?php echo (isset($styled) && $styled) ? '' : ' img-fluid'; ?>"
                                     alt="<?php echo htmlspecialchars($p['product_name']); ?>">
                            <?php endif; ?>
                            <div class="card-body<?php echo (isset($styled) && $styled) ? '' : ' p-0'; ?>">
                                <h6 class="card-title<?php echo (isset($styled) && $styled) ? '' : ' mb-1'; ?>">
                                    <?php echo htmlspecialchars($p['product_name']); ?>
                                </h6>
                                <p class="card-text small mb-2">
                                    <?php echo substr(htmlspecialchars($p['product_description']), 0, 100); ?>...
                                </p>
                                <p class="fw-bold text-success">
                                    <?php echo app_format_money($p['rate'], $base_currency->name); ?>
                                </p>
                                <a href="<?php echo site_url('products/widget_single/' . $p['id']); ?>" 
                                   class="btn btn-sm btn-outline-primary">View</a>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            <?php endif; ?>
        </div>
    </div>

    <?php if (isset($styled) && $styled): ?>
        <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <?php endif; ?>
</body>
</html>
