<?php
defined('BASEPATH') or exit('No direct script access allowed');

// Guard to prevent double execution
if (defined('QUERY_CONTACT_TABLE_LOADED')) {
    return;
}
define('QUERY_CONTACT_TABLE_LOADED', true);

$aColumns = [
    'product_name',
	'product_url',
    'username',
    'email',
    'phonenumber',
    'created_at',
];
$sIndexColumn = 'id';
$sTable = db_prefix() . 'query_contact';
$join = [];
$where = [];
$filter = [];
$result = data_tables_init($aColumns, $sIndexColumn, $sTable, $join, $where);
$output = $result['output'];
$rResult = $result['rResult'];

// Ensure numeric fields are integers (minor issue: they're strings in your JSON, which DataTables tolerates but may cause edge-case warnings)
$output['draw'] = (int) $output['draw'];
$output['iTotalRecords'] = (int) $output['iTotalRecords'];
$output['iTotalDisplayRecords'] = (int) $output['iTotalDisplayRecords'];

foreach ($rResult as $aRow) {
    $row = [];
    $row[] = $aRow['product_name'];
	if (!empty($aRow['product_url'])) {
        $safe_url = htmlspecialchars($aRow['product_url']);
        $row[] = '<a href="' . $safe_url . '" target="_blank" rel="noopener noreferrer">'
               . $safe_url . '</a>';
    } else {
        $row[] = '-';
    }
    $row[] = htmlspecialchars($aRow['username']);
    $row[] = '<a href="mailto:' . htmlspecialchars($aRow['email']) . '">' . htmlspecialchars($aRow['email']) . '</a>';
    $row[] = '<a href="tel:' . htmlspecialchars($aRow['phonenumber']) . '">' . htmlspecialchars($aRow['phonenumber']) . '</a>';
    $row[] = _dt($aRow['created_at']);
    $output['aaData'][] = $row;
}
//echo json_encode($output);
?>