<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<div class="modal fade" id="lead_campaign_status_modal" tabindex="-1" role="dialog">
   <div class="modal-dialog">
      <?= form_open(admin_url('lead_campaigns/status'), ['id' => 'lead-campaign-status-form']); ?>
      <div class="modal-content">
         <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
               <span aria-hidden="true">&times;</span>
            </button>
            <h4 class="modal-title">
               <span class="edit-title"><?= _l('edit_status'); ?></span>
               <span class="add-title"><?= _l('lead_campaign_new_status'); ?></span>
            </h4>
         </div>
         <div class="modal-body">
            <div class="row">
               <div class="col-md-12">
                  <div id="status_additional"></div>
                  <?= render_input('name', 'lead_campaign_status_name'); ?>
                  <?= render_color_picker('color', _l('lead_campaign_status_color')); ?>
                  <?= render_input('statusorder', 'lead_campaign_status_order', '', 'number'); ?>
               </div>
            </div>
         </div>
         <div class="modal-footer">
            <button type="button" class="btn btn-default" data-dismiss="modal"><?= _l('close'); ?></button>
            <button type="submit" class="btn btn-primary"><?= _l('submit'); ?></button>
         </div>
      </div>
      <?= form_close(); ?>
   </div>
</div>

<script>
  $(function () {
    appValidateForm($('#lead-campaign-status-form'), {
      name: 'required'
    }, manage_campaign_statuses);

    $('#lead_campaign_status_modal').on("hidden.bs.modal", function () {
      $('#status_additional').html('');
      $('#lead_campaign_status_modal input[name="name"]').val('');
      $('#lead_campaign_status_modal input[name="color"]').val('');
      $('#lead_campaign_status_modal input[name="statusorder"]').val('');
      $('.add-title').removeClass('hide');
      $('.edit-title').removeClass('hide');
    });
  });

  function new_campaign_status() {
    $('#lead_campaign_status_modal').modal('show');
    $('.edit-title').addClass('hide');
  }

  function edit_campaign_status(invoker, id) {
    $('#status_additional').append(hidden_input('id', id));
    $('#lead_campaign_status_modal input[name="name"]').val($(invoker).data('name'));
    $('#lead_campaign_status_modal .colorpicker-input').colorpicker('setValue', $(invoker).data('color'));
    $('#lead_campaign_status_modal input[name="statusorder"]').val($(invoker).data('order'));
    $('#lead_campaign_status_modal').modal('show');
    $('.add-title').addClass('hide');
  }

  function manage_campaign_statuses(form) {
    var data = $(form).serialize();
    var url = form.action;
    $.post(url, data).done(function () {
      window.location.reload();
    });
    return false;
  }
</script>
