<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>

<div id="wrapper">
    <div class="content">
        <div class="row">
            <div class="col-md-12">
                <div class="tw-mb-2">
                    <a href="#" onclick="new_campaign(); return false;" class="btn btn-primary">
                        <i class="fa fa-plus"></i>
                        <?= _l('new_lead_campaign'); ?>
                    </a>
                </div>
                <div class="panel_s">
                    <div class="panel-body panel-table-full">
                        <?php if (count($campaigns) > 0) { ?>
                            <table class="table dt-table" data-order-col="0" data-order-type="asc">
                                <thead>
                                    <tr>
                                        <th><?= _l('id'); ?></th>
                                        <th><?= _l('campaign_name'); ?></th>
                                        <th><?= _l('status'); ?></th>
                                        <th><?= _l('options'); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach ($campaigns as $campaign) { ?>
                                        <tr>
                                            <td><?= e($campaign['id']); ?></td>
                                            <td><?= e($campaign['name']); ?></td>
                                            <td><?= e(ucfirst($campaign['status'])); ?></td>
                                            <td>
                                                <a href="#" onclick="edit_campaign(this, <?= e($campaign['id']); ?>); return false;"
                                                   data-name="<?= e($campaign['name']); ?>"
                                                   data-status="<?= e($campaign['status']); ?>"
                                                   class="btn btn-sm btn-default">
                                                    <i class="fa fa-pencil"></i>
                                                </a>
                                                <a href="<?= admin_url('leadcampaigns/delete/' . $campaign['id']); ?>"
                                                   class="btn btn-sm btn-danger _delete">
                                                    <i class="fa fa-remove"></i>
                                                </a>
                                            </td>
                                        </tr>
                                    <?php } ?>
                                </tbody>
                            </table>
                        <?php } else { ?>
                            <p class="text-muted"><?= _l('no_lead_campaigns_found'); ?></p>
                        <?php } ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php $this->load->view('modal'); ?>
<?php init_tail(); ?>
