<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Leadcampaigns_model extends App_Model
{
    public function __construct()
    {
        parent::__construct();
    }

    public function get($id = '', $where = [])
    {
        if (is_numeric($id)) {
            $this->db->where('id', $id);
            return $this->db->get(db_prefix() . 'leadcampaigns')->row();
        }

        if (!empty($where)) {
            $this->db->where($where);
        }

        return $this->db->get(db_prefix() . 'leadcampaigns')->result_array();
    }

    public function add($data)
    {
        $this->db->insert(db_prefix() . 'leadcampaigns', $data);
        $insert_id = $this->db->insert_id();
        if ($insert_id) {
            log_activity('New Lead Campaign Added [ID: ' . $insert_id . ']');
        }
        return $insert_id;
    }

    public function update($id, $data)
    {
        $this->db->where('id', $id);
        $updated = $this->db->update(db_prefix() . 'leadcampaigns', $data);
        if ($updated) {
            log_activity('Lead Campaign Updated [ID: ' . $id . ']');
        }
        return $updated;
    }

    public function delete($id)
    {
        $this->db->where('id', $id);
        $deleted = $this->db->delete(db_prefix() . 'leadcampaigns');
        if ($deleted) {
            log_activity('Lead Campaign Deleted [ID: ' . $id . ']');
        }
        return $deleted;
    }
}
